/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Map;
import org.hibernate.Query;

public class LabelPageContentDataset
extends DefaultORMDataset<LabelPageContent> {
    static ESLLogger logger = ESLLogger.getLogger(LabelPageContentDataset.class);

    public LabelPageContentDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(LabelPageContent.class, datasetPermissions);
    }

    public void cleanupContent(Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("delete from LabelPageContent where not exists (from RegisteredLabel r where r.label = label) or updateImage is NULL");
        int deletedRows = ormTransaction.executeUpdate(query);
        logger.info("Deleted %d label page content rows", new Object[]{deletedRows});
    }

    public LabelPageContent queryByLabelAndPage(LabelId label, Page page, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select l from LabelPageContent l where l.page = :page and l.label = :label order by l.id DESC");
        query.setMaxResults(1);
        query.setInteger("page", page.getPageIndex());
        query.setLong("label", label.getId());
        return ormTransaction.querySingleRow(query, LabelPageContent.class);
    }

    public void deleteByLabelAndPage(LabelId label, Page page, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("delete from LabelPageContent where page = :page and label = :label order by id DESC");
        query.setInteger("page", page.getPageIndex());
        query.setLong("label", label.getId());
        ormTransaction.executeUpdate(query);
    }
}

