/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Calendar;
import java.util.Map;
import org.hibernate.Query;

public class LabelInfoHistoryDataset
extends DefaultORMDataset<LabelInfoHistoryRecord> {
    static ESLLogger logger = ESLLogger.getLogger(LabelInfoHistoryDataset.class);

    public LabelInfoHistoryDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(LabelInfoHistoryRecord.class, datasetPermissions);
    }

    public int cleanupHistory(int daysToKeep, int maxCleanupRecords, Transaction<?> transaction) throws DatasetException {
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.add(5, -daysToKeep);
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        logger.info("Deleting label info history records with updateAt before %s", new Object[]{cleanupTime.getTime()});
        Query update = ormTransaction.createQuery("delete from LabelInfoHistoryRecord where createdAt < :cleanupTime");
        update.setTimestamp("cleanupTime", cleanupTime.getTime());
        int deletedRows = ormTransaction.executeUpdate(update);
        logger.info("Deleted %d label info history rows", new Object[]{deletedRows});
        return deletedRows;
    }
}

