/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelEventRecord;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Calendar;
import java.util.Map;
import org.hibernate.Query;

public class LabelEventDataset
extends DefaultORMDataset<LabelEventRecord> {
    static ESLLogger logger = ESLLogger.getLogger(LabelEventDataset.class);

    public LabelEventDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(LabelEventRecord.class, datasetPermissions);
    }

    public int cleanupEvents(int daysToKeep, int maxCleanupRecords, Transaction<?> transaction) throws DatasetException {
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.add(5, -daysToKeep);
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        logger.info("Deleting label event records with updateAt before %s", new Object[]{cleanupTime.getTime()});
        Query update = ormTransaction.createQuery("select l from LabelEventRecord l where l.updatedAt < :cleanupTime");
        update.setTimestamp("cleanupTime", cleanupTime.getTime());
        update.setMaxResults(maxCleanupRecords);
        int deletedRows = ormTransaction.deleteFromQuery(update);
        logger.info("Deleted %d label event rows", new Object[]{deletedRows});
        return deletedRows;
    }
}

