/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.joda.time.DateTime;

public class LabelDetailDataset
extends DefaultORMDataset<LabelDetail> {
    static ESLLogger logger = ESLLogger.getLogger(LabelInfoHistoryDataset.class);

    public LabelDetailDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(LabelDetail.class, datasetPermissions);
    }

    public int cleanupHistory(int daysToKeep, int maxCleanupRecords, Transaction<?> transaction) throws DatasetException {
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.add(5, -daysToKeep);
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        logger.info("Deleting label detail records with updateAt before %s", new Object[]{cleanupTime.getTime()});
        Query update = ormTransaction.createQuery("delete from LabelDetail where createdAt < :cleanupTime");
        update.setTimestamp("cleanupTime", cleanupTime.getTime());
        int deletedRows = ormTransaction.executeUpdate(update);
        logger.info("Deleted %d label detail rows", new Object[]{deletedRows});
        return deletedRows;
    }

    public List<LabelDetail> queryLabelDetailsForLabel(LabelId labelId, DateTime maxRecordAge, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select d from LabelDetail d where d.label = :label and d.id in (select max(dd.id) from LabelDetail dd where dd.label = :label and dd.createdAt > :maxAge group by dd.type, dd.dataId)");
        query.setLong("label", labelId.getId());
        query.setTimestamp("maxAge", maxRecordAge.toDate());
        return ormTransaction.query(query, LabelDetail.class);
    }

    public List<LabelDetail> queryLabelDetailsForLabel(LabelId labelId, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select d from LabelDetail d where d.label = :label and d.id in (select max(dd.id) from LabelDetail dd where dd.label = :label group by dd.type, dd.dataId)");
        query.setLong("label", labelId.getId());
        return ormTransaction.query(query, LabelDetail.class);
    }

    public LabelDetail queryByLabel(LabelId labelId, LabelDetailType type, int dataId, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select d from LabelDetail d where d.label = :label and d.type = :type and d.dataId = :dataId order by updatedAt desc");
        query.setParameter("label", (Object)labelId.getId());
        query.setParameter("type", (Object)type);
        query.setParameter("dataId", (Object)dataId);
        query.setMaxResults(1);
        List<LabelDetail> result = ormTransaction.query(query, LabelDetail.class);
        if (result != null && !result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }
}

