/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelActivePage;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Map;
import org.hibernate.Query;

public class LabelActivePageDataset
extends DefaultORMDataset<LabelActivePage> {
    static ESLLogger logger = ESLLogger.getLogger(LabelActivePageDataset.class);

    public LabelActivePageDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(LabelActivePage.class, datasetPermissions);
    }

    public void cleanupContent(Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select l from LabelActivePage l where not exists (from RegisteredLabel r where r.label = l.label)");
        int deletedRows = ormTransaction.deleteFromQuery(query);
        logger.info("Deleted %d label active page rows", new Object[]{deletedRows});
    }

    public LabelActivePage queryByLabel(LabelId label, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select l from LabelActivePage l where l.label = :label)");
        query.setLong("label", label.getId());
        return ormTransaction.querySingleRow(query, LabelActivePage.class);
    }
}

