/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.FirmwareRecord;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class FirmwareDataset
extends AbstractDataset<FirmwareRecord> {
    static ESLLogger logger = ESLLogger.getLogger(FirmwareDataset.class);
    public static final String[] FIRMWARE_EXTENSIONS = new String[]{"hex", "xml"};
    private List<FirmwareRecord> firmwareFiles = new ArrayList<FirmwareRecord>();

    public FirmwareDataset(Map<Role, DatasetPermissions> datasetPermissions) throws DatasetException, InitializationException {
        super(FirmwareRecord.class, datasetPermissions);
        this.reload((Transaction<?>)NoTransaction.get());
    }

    public FirmwareRecord queryById(long id, Transaction<?> transaction) throws DatasetException {
        throw new DatasetException("Query by ID not implemented", new Object[0]);
    }

    public synchronized List<FirmwareRecord> queryAll(Transaction<?> transaction) throws DatasetException {
        return Collections.unmodifiableList(new ArrayList<FirmwareRecord>(this.firmwareFiles));
    }

    public synchronized int getRecordCount(Transaction<?> transaction) {
        return this.firmwareFiles.size();
    }

    public void store(Collection<FirmwareRecord> records, UserId user, Transaction<?> transaction) {
    }

    public void delete(Collection<FirmwareRecord> records, UserId user, Transaction<?> transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abortable reload(Transaction<?> transaction) throws DatasetException {
        logger.debug("Reloading firmware files");
        File directory = new File(Config.getFirmwarePath());
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FilenameUtils.isExtension((String)file.getAbsolutePath(), (String[])FIRMWARE_EXTENSIONS);
            }
        };
        long firmwareId = 0L;
        ArrayList<FirmwareRecord> firmwareFiles = new ArrayList<FirmwareRecord>();
        if (directory.exists() && directory.isDirectory()) {
            for (File firmwareFile : directory.listFiles(fileFilter)) {
                FirmwareRecord firmware = new FirmwareRecord(firmwareId++, firmwareFile.getName());
                firmwareFiles.add(firmware);
            }
        } else {
            logger.debug("Firmware directory '%s' not found", new Object[]{directory.getAbsolutePath()});
        }
        FirmwareDataset firmwareDataset = this;
        synchronized (firmwareDataset) {
            this.firmwareFiles.clear();
            this.firmwareFiles.addAll(firmwareFiles);
        }
        this.notifyRecordsModified(firmwareFiles, transaction);
        return Abortable.DO_NOTHING;
    }

    public void close() {
    }
}

