/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.record.DatabaseIdentifier;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import java.util.UUID;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class DatabaseIdentifierDataset {
    private final SessionFactory sessionFactory;
    private final DatabaseIdentifier databaseIdentifier;

    public DatabaseIdentifierDataset(SessionFactory sessionFactory, UUID initialDatabaseId) throws DatasetException {
        this.sessionFactory = sessionFactory;
        this.databaseIdentifier = this.initializeIdentifier(initialDatabaseId);
    }

    private DatabaseIdentifier initializeIdentifier(UUID initialDatabaseId) throws DatasetException {
        Query query;
        ORMTransaction<?> transaction = this.newTransaction();
        DatabaseIdentifier identifier = transaction.querySingleRow(query = transaction.createQuery("from DatabaseIdentifier"), DatabaseIdentifier.class);
        if (identifier == null) {
            ORMTransaction<?> insertTransaction = this.newTransaction();
            try {
                identifier = new DatabaseIdentifier(initialDatabaseId != null ? initialDatabaseId : UUID.randomUUID());
                insertTransaction.getSession().save((Object)identifier);
                insertTransaction.commit();
            }
            catch (Exception exc) {
                insertTransaction.rollback();
                throw new DatasetException((Throwable)exc);
            }
        }
        return identifier;
    }

    private ORMTransaction<?> newTransaction() throws DatasetException {
        return new ORMTransaction((Session)this.sessionFactory.getCurrentSession());
    }

    public UUID getDatabaseIdentifier() {
        return this.databaseIdentifier.getDatabaseId();
    }
}

