/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetRecordNotFoundException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collections;
import java.util.Map;
import org.hibernate.Query;

public class ConfigurationDataset
extends DefaultORMDataset<Configuration> {
    public ConfigurationDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(Configuration.class, datasetPermissions);
    }

    @Override
    protected String getDefaultOrderClause() {
        return " order by t.key";
    }

    public Configuration getConfiguration(String key, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("from Configuration c where c.key = :key").setParameter("key", (Object)key);
        return ormTransaction.querySingleRow(query, Configuration.class);
    }

    public void updateConfiguration(String key, String value, UserId user, Transaction<?> transaction) throws DatasetException {
        Configuration configuration = this.getConfiguration(key, transaction);
        if (configuration != null) {
            configuration.setValue(value);
            try {
                configuration.validate();
            }
            catch (SerializeException exc) {
                throw new DatasetException((Throwable)exc);
            }
        } else {
            throw new DatasetRecordNotFoundException("Configuration key not found", new Object[0]);
        }
        this.store(Collections.singleton(configuration), user, transaction);
    }
}

