/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.BatteryReplacementRecord;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Calendar;
import java.util.Map;
import org.hibernate.Query;

public class BatteryReplacementRecordDataset
extends DefaultORMDataset<BatteryReplacementRecord> {
    static ESLLogger logger = ESLLogger.getLogger(BatteryReplacementRecordDataset.class);

    public BatteryReplacementRecordDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(BatteryReplacementRecord.class, datasetPermissions);
    }

    public int cleanupHistory(int daysToKeep, int maxCleanupRecords, Transaction<?> transaction) throws DatasetException {
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.add(5, -daysToKeep);
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        logger.info("Deleting battery replacement records with createdAt before %s", new Object[]{cleanupTime.getTime()});
        Query update = ormTransaction.createQuery("select b from BatteryReplacementRecord b where b.createdAt < :cleanupTime order by b.updatedAt ASC");
        update.setTimestamp("cleanupTime", cleanupTime.getTime());
        update.setMaxResults(maxCleanupRecords);
        int deletedRows = ormTransaction.deleteFromQuery(update);
        logger.info("Deleted %d battery replacement rows", new Object[]{deletedRows});
        return deletedRows;
    }
}

