/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdatePackageRecord;
import at.mrdevelopment.esl.update.UpdatePackageInformation;
import at.mrdevelopment.esl.xml.UpdatePackageXMLSerializer;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.checksum.AbstractDigest;
import at.mrdevelopment.toolkit.checksum.SHA1;
import at.mrdevelopment.toolkit.file.UpdateDecompressor;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FilenameUtils;

public class AccessPointUpdatePackageDataset
extends AbstractDataset<AccessPointUpdatePackageRecord> {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointUpdatePackageDataset.class);
    public static final String[] EXTENSIONS = new String[]{"tgz", "TGZ"};
    private final UpdatePackageXMLSerializer serializer;
    private final AbstractDigest digest;
    private List<AccessPointUpdatePackageRecord> records = new ArrayList<AccessPointUpdatePackageRecord>();
    private volatile boolean initialized = false;
    private int listenPort;
    private boolean ssl;

    public AccessPointUpdatePackageDataset(Map<Role, DatasetPermissions> datasetPermissions) throws DatasetException, InitializationException {
        super(AccessPointUpdatePackageRecord.class, datasetPermissions);
        this.serializer = new UpdatePackageXMLSerializer();
        try {
            this.digest = new SHA1();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public AccessPointUpdatePackageRecord queryById(long id, Transaction<?> transaction) throws DatasetException {
        if (id < (long)this.records.size()) {
            return this.records.get((int)id);
        }
        return null;
    }

    public synchronized List<AccessPointUpdatePackageRecord> queryAll(Transaction<?> transaction) throws DatasetException {
        return Collections.unmodifiableList(new ArrayList<AccessPointUpdatePackageRecord>(this.records));
    }

    public synchronized int getRecordCount(Transaction<?> transaction) {
        return this.records.size();
    }

    public void store(Collection<AccessPointUpdatePackageRecord> records, UserId user, Transaction<?> transaction) {
    }

    public void delete(Collection<AccessPointUpdatePackageRecord> records, UserId user, Transaction<?> transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Abortable reload(Transaction<?> transaction) throws DatasetException {
        logger.debug("Reloading access point update packages");
        File directory = new File(Config.getAccessPointUpdatePackagePath());
        ArrayList<AccessPointUpdatePackageRecord> updates = new ArrayList<AccessPointUpdatePackageRecord>();
        ArrayList<AccessPointUpdatePackageRecord> remove = new ArrayList<AccessPointUpdatePackageRecord>();
        long recordId = 0L;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FilenameUtils.isExtension((String)file.getName(), (String[])EXTENSIONS);
            }
        };
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles(fileFilter);
            if (files != null) {
                for (AccessPointUpdatePackageRecord record : this.records) {
                    if (this.containsUpdateRecord(Arrays.asList(files), record)) continue;
                    remove.add(record);
                }
                Object i$ = this;
                synchronized (i$) {
                    this.records.removeAll(remove);
                }
                for (File updateFile : files) {
                    InputStream updateXMLStream;
                    block19: {
                        if (this.containsUpdateFile(this.records, updateFile.getName())) continue;
                        updateXMLStream = null;
                        try {
                            updateXMLStream = UpdateDecompressor.untargzFile((File)updateFile, (String)"update.xml", (boolean)false);
                            if (updateXMLStream != null) {
                                UpdatePackageInformation packageInformation = this.serializer.parsePackageInformation(updateXMLStream);
                                String checksum = this.digest.getChecksum(updateFile);
                                updates.add(new AccessPointUpdatePackageRecord(recordId++, packageInformation, updateFile, DatatypeConverter.parseHexBinary((String)checksum), this.listenPort, this.ssl));
                                break block19;
                            }
                            logger.info("Could not load update package information from file %s", new Object[]{updateFile.getName()});
                        }
                        catch (SerializeException exc) {
                            logger.warn("Could not parse update package information from file %s: %s", new Object[]{updateFile.getName(), exc.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc);
                            StreamUtils.close((InputStream)updateXMLStream);
                            continue;
                        }
                        catch (IOException exc2) {
                            logger.warn("Could not parse update package information from file %s: %s", new Object[]{updateFile.getName(), exc2.getMessage()});
                            logger.logExceptionIfDebugEnabled((Throwable)exc2);
                            {
                                catch (Throwable throwable) {
                                    StreamUtils.close(updateXMLStream);
                                    throw throwable;
                                }
                            }
                            StreamUtils.close((InputStream)updateXMLStream);
                            continue;
                        }
                    }
                    StreamUtils.close((InputStream)updateXMLStream);
                }
            } else {
                logger.debug("Unable to list access point update package directory '%s'", new Object[]{directory.toString()});
            }
        }
        AccessPointUpdatePackageDataset accessPointUpdatePackageDataset = this;
        synchronized (accessPointUpdatePackageDataset) {
            this.records.addAll(updates);
        }
        if (!updates.isEmpty()) {
            this.notifyRecordsModified(updates, transaction);
        }
        this.initialized = true;
        return Abortable.DO_NOTHING;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPointUpdatePackageRecord getUpdatePackage(AccessPointInfo accessPointInfo) {
        Version latestVersion = null;
        AccessPointUpdatePackageRecord latestPackage = null;
        Version version = accessPointInfo.getVersion();
        String accessPointType = accessPointInfo.getTypeIdentifier();
        AccessPointUpdatePackageDataset accessPointUpdatePackageDataset = this;
        synchronized (accessPointUpdatePackageDataset) {
            for (AccessPointUpdatePackageRecord record : this.records) {
                if (record.getAccessPointType() == null || !record.getAccessPointType().equals(accessPointType) || version == null || version.isEqual(Version.UNDEFINED) || !record.getUpdateVersion().isNewer(version) || !record.getRequiredVersion().match((Comparable)version) || latestVersion != null && !record.getUpdateVersion().isNewer(latestVersion)) continue;
                latestVersion = record.getUpdateVersion();
                latestPackage = record;
            }
        }
        return latestPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPointUpdatePackageRecord queryByChecksum(byte[] checksum) {
        AccessPointUpdatePackageDataset accessPointUpdatePackageDataset = this;
        synchronized (accessPointUpdatePackageDataset) {
            for (AccessPointUpdatePackageRecord record : this.records) {
                if (!Arrays.equals(record.getChecksum(), checksum)) continue;
                return record;
            }
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void updateConnectionSettings(int listenPort, boolean ssl) {
        this.listenPort = listenPort;
        this.ssl = ssl;
    }

    private boolean containsUpdateFile(List<AccessPointUpdatePackageRecord> records, final String filename) {
        return !Collections2.filter(records, (Predicate)new Predicate<AccessPointUpdatePackageRecord>(){

            public boolean apply(AccessPointUpdatePackageRecord record) {
                return record.getUpdatePackageFileName().equalsIgnoreCase(filename);
            }
        }).isEmpty();
    }

    private boolean containsUpdateRecord(List<File> files, final AccessPointUpdatePackageRecord record) {
        return !Collections2.filter(files, (Predicate)new Predicate<File>(){

            public boolean apply(File file) {
                return file.getName().equalsIgnoreCase(record.getUpdatePackageFileName());
            }
        }).isEmpty();
    }
}

