/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licensing;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.configuration.ConfigurationChangedListener;
import at.mrdevelopment.esl.licencing.DefaultLicenseReader;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.licencing.LicenseReader;
import at.mrdevelopment.esl.licensing.LicenseReloadListener;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LicenceRecord;
import at.mrdevelopment.esl.persistence.validator.LicenceRecordValidator;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.licensing.SystemSerial;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Strings;
import com.imagotag.esl.license.LancomLicenseReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class LicenseManager
implements DatasetModifiedListener<LicenceRecord>,
ConfigurationChangedListener {
    static ESLLogger logger = ESLLogger.getLogger(LicenseManager.class);
    private final Dataset<LicenceRecord> dataset;
    private final LicenseReader licenseReader;
    private final FeatureUnlock featureUnlock;
    private final Set<LicenseReloadListener> reloadListeners = new HashSet<LicenseReloadListener>();

    public LicenseManager(ORMDataset<LicenceRecord> dataset, SystemSerial.SystemType type, int deviceId) throws InitializationException, SerializeException, DatasetException {
        this.dataset = dataset;
        this.licenseReader = this.newLicenseReader(type, deviceId);
        this.featureUnlock = new FeatureUnlock(this.licenseReader);
        dataset.registerRecordValidator(new LicenceRecordValidator(this));
    }

    public void init(Transaction<?> transaction) throws DatasetException {
        this.reload(this.dataset.queryAll(transaction), transaction);
    }

    private LicenseReader newLicenseReader(SystemSerial.SystemType type, int deviceId) throws InitializationException {
        if (Config.getLicenseManager().toLowerCase().equals("lancom")) {
            logger.info("Using LANCOM license manager");
            return new LancomLicenseReader(this.getSiteName());
        }
        if (type == null) {
            logger.info("Using default license manager");
            return new DefaultLicenseReader(Config.getPreferredNetworkInterface());
        }
        logger.info("Using default license manager in appliance mode");
        return new DefaultLicenseReader(type, deviceId);
    }

    private String getSiteName() {
        String storeId = Config.getStoreId();
        return Strings.isNullOrEmpty((String)storeId) ? "DefaultSite" : storeId;
    }

    private void reload(Iterable<LicenceRecord> licenses, Transaction<?> transaction) {
        this.licenseReader.reset();
        this.featureUnlock.reset();
        for (LicenceRecord record : licenses) {
            try {
                logger.info("Processing license '%s'", new Object[]{record.getComment()});
                String licenseKey = record.getLicenceKey();
                this.featureUnlock.processLicense(licenseKey);
            }
            catch (SerializeException exc) {
                logger.warn("Failed to load license: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        for (LicenseReloadListener listener : this.reloadListeners) {
            listener.licenseReloaded(transaction);
        }
    }

    public void recordsModified(Collection<LicenceRecord> records, Transaction<?> transaction) {
        try {
            this.reload(this.dataset.queryAll(transaction), transaction);
        }
        catch (DatasetException exc) {
            logger.error("Could not read license records");
        }
    }

    public FeatureUnlock getUnlockedFeatures() {
        return this.featureUnlock;
    }

    public boolean isValidLicense(LicenceRecord record) {
        return this.licenseReader.isValidLicense(record.getLicenceKey());
    }

    @Override
    public void configurationChanged(String key, String value, Transaction<?> transaction) throws DatasetException {
        if (key.equals("storeId") && this.licenseReader instanceof LancomLicenseReader) {
            ((LancomLicenseReader)this.licenseReader).setSiteName(value);
            this.reload(this.dataset.queryAll(transaction), transaction);
        }
    }

    public void registerLicenseReloadListener(LicenseReloadListener listener) {
        this.reloadListeners.add(listener);
    }

    public void unregisterLicenseReloadListener(LicenseReloadListener listener) {
        this.reloadListeners.remove(listener);
    }
}

