/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey;

import at.mrdevelopment.esl.jersey.FilterPriority;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.RequestHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.RequestHistoryRecord;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.grizzly.http.server.Request;
import org.joda.time.DateTime;

@FilterPriority(value=0)
public class JerseyLoggingHandler
implements ContainerRequestFilter,
ContainerResponseFilter {
    static ESLLogger logger = ESLLogger.getLogger(JerseyLoggingHandler.class);
    @Context
    private ThreadLocal<Request> request;
    private final Map<ContainerRequest, DateTime> timestamps = new ConcurrentHashMap<ContainerRequest, DateTime>();
    private final RequestHistoryDataset requestHistoryDataset;

    public JerseyLoggingHandler(RequestHistoryDataset requestHistoryDataset) {
        this.requestHistoryDataset = requestHistoryDataset;
    }

    public ContainerResponse filter(ContainerRequest containerRequest, ContainerResponse containerResponse) {
        Long requestId = this.parseRequestId(containerRequest);
        DateTime requestTimestamp = this.timestamps.remove(containerRequest);
        if (requestId != null && requestTimestamp != null) {
            long elapsedTime = DateTime.now().getMillis() - requestTimestamp.getMillis();
            String remoteAddress = this.request.get().getRemoteAddr();
            String uri = containerRequest.getRequestUri().toString();
            String requestMethod = containerRequest.getMethod();
            String userAgent = containerRequest.getHeaderValue("User-Agent");
            int httpStatus = containerResponse.getResponse().getStatus();
            String errorMessage = this.parseErrorMessage(containerResponse);
            String principal = null;
            String authScheme = null;
            SecurityContext securityContext = containerRequest.getSecurityContext();
            if (securityContext != null) {
                principal = securityContext.getUserPrincipal() != null ? securityContext.getUserPrincipal().getName() : null;
                authScheme = securityContext.getAuthenticationScheme();
            }
            RequestHistoryRecord requestHistoryRecord = new RequestHistoryRecord(requestId, requestTimestamp, requestMethod, uri, remoteAddress, userAgent, elapsedTime, httpStatus, principal, authScheme, errorMessage);
            this.logRecord(requestHistoryRecord);
            this.requestHistoryDataset.store((Collection<RequestHistoryRecord>)Collections.singleton(requestHistoryRecord), UserId.SYSTEM, (Transaction<?>)NoTransaction.get());
        }
        return containerResponse;
    }

    private void logRecord(RequestHistoryRecord record) {
        logger.info("Request %d (%d ms): [%s] %s [%d]", new Object[]{record.getId(), record.getElapsedTime(), record.getMethod(), record.getUri(), record.getStatus()});
        logger.debug("Request %d details: remoteAddress=%s, user-agent=%s, authSchema=%s, principal=%s, errorMessage=%s ", new Object[]{record.getId(), record.getRemoteAddress(), record.getUserAgent(), record.getAuthScheme(), record.getPrincipal(), record.getErrorMessage()});
    }

    private String parseErrorMessage(ContainerResponse containerResponse) {
        if (containerResponse.getMappedThrowable() != null) {
            Throwable throwable = containerResponse.getMappedThrowable();
            if (throwable instanceof WebApplicationException) {
                WebApplicationException exception = (WebApplicationException)throwable;
                Object entity = exception.getResponse().getEntity();
                if (entity != null) {
                    return entity.toString();
                }
            } else {
                String cause = throwable.getCause() != null ? String.format("Caused by %s: %s", throwable.getCause().getClass().getSimpleName(), throwable.getCause().getMessage()) : throwable.getMessage();
                return String.format("%s: %s", throwable.getClass().getSimpleName(), cause);
            }
        }
        return null;
    }

    public ContainerRequest filter(ContainerRequest containerRequest) {
        this.timestamps.put(containerRequest, DateTime.now());
        return containerRequest;
    }

    private Long parseRequestId(ContainerRequest containerRequest) {
        try {
            return Long.parseLong(containerRequest.getProperties().get("request-id").toString());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

