/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey;

import at.mrdevelopment.esl.admin.platform.NetworkProperty;
import at.mrdevelopment.esl.network.NetworkStatus;
import at.mrdevelopment.esl.network.NetworkStatusGenerator;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class DisabledNetworkInterfaceFilter
extends BaseFilter {
    static ESLLogger logger = ESLLogger.getLogger(DisabledNetworkInterfaceFilter.class);
    private final Collection<String> disabledNetworkInterfaces;
    private final NetworkStatusGenerator networkStatusGenerator;

    public DisabledNetworkInterfaceFilter(Collection<String> disabledNetworkInterfaces, NetworkStatusGenerator networkStatusGenerator) {
        this.disabledNetworkInterfaces = disabledNetworkInterfaces;
        this.networkStatusGenerator = networkStatusGenerator;
    }

    public NextAction handleAccept(FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        NetworkStatus networkStatus = this.networkStatusGenerator.getNetworkStatus();
        if (connection.getLocalAddress() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)connection.getLocalAddress();
            for (NetworkProperty property : networkStatus.getNetworkProperties()) {
                if (!this.disabledNetworkInterfaces.contains(property.getInterfaceName()) || !property.getInetAddress().toString().equals(address.getAddress().toString())) continue;
                logger.info("Connection blocked: source=%s, destination=%s (%s)", new Object[]{connection.getPeerAddress().toString(), property.getAddress(), property.getInterfaceName()});
                connection.closeSilently();
                return context.getStopAction();
            }
        }
        return context.getInvokeAction();
    }

    public Collection<String> getDisabledInterfaces() {
        return Collections.unmodifiableCollection(this.disabledNetworkInterfaces);
    }
}

