/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.http;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.MultipartFileParser;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Route(route="/service/template")
public class TemplateRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(TemplateRequestHandler.class);
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restrict
    @Route(method=HttpRequestMethod.POST, route="upload.html")
    public void uploadTemplate(WebserviceRequest request, WebserviceResponse response) throws IOException, SerializeException {
        block10: {
            block9: {
                ByteArrayInputStream inputStream;
                ByteArrayOutputStream outputStream;
                block8: {
                    HttpEntity body = request.getBody();
                    if (!body.getContentType().getValue().contains("multipart/form-data")) break block9;
                    MultipartFileParser parser = new MultipartFileParser();
                    outputStream = null;
                    inputStream = null;
                    try {
                        outputStream = new ByteArrayOutputStream();
                        String fileName = parser.writeFileFromStream(body, (OutputStream)outputStream);
                        if (fileName != null) {
                            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                            if (FilenameUtils.isExtension((String)fileName, (String[])new String[]{"xsl", "XSL"})) {
                                try {
                                    File templateFile = new File(Config.getTemplatePath(), fileName);
                                    if (templateFile.exists()) {
                                        FileUtils.deleteQuietly((File)templateFile);
                                    }
                                    Element root = this.xmlToolkit.getDocumentRootFromInputStream((InputStream)inputStream);
                                    Document templateDocument = root.getOwnerDocument();
                                    this.xmlToolkit.transform((Source)new DOMSource(templateDocument), (Result)new StreamResult(templateFile));
                                    response.respondMessage(String.format("Template %s uploaded.", templateFile.getName()));
                                }
                                catch (Exception exc) {
                                    logger.warn("Failed to store template file %s: %s", new Object[]{fileName, exc.getMessage()});
                                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                                    response.respondMessage(String.format("Failed to store template file %s: %s", fileName, exc.getMessage()), 400);
                                }
                            } else {
                                response.respondMessage(String.format("Wrong template file extension %s", fileName), 400);
                            }
                            break block8;
                        }
                        response.respondMessage(String.format("Could not read template file", new Object[0]), 400);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close((OutputStream)outputStream);
                        StreamUtils.close(inputStream);
                        throw throwable;
                    }
                }
                StreamUtils.close((OutputStream)outputStream);
                StreamUtils.close((InputStream)inputStream);
                break block10;
            }
            response.respondBadRequest();
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="delete/.*")
    public void deleteTemplate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String template = StringUtils.substringAfterLast((String)request.getRequestUri().getPath(), (String)"delete/");
        if (template != null && FilenameUtils.isExtension((String)template, (String[])new String[]{"XSL", "xsl"})) {
            File templateFile = new File(Config.getTemplatePath(), new File(template).getName());
            if (!templateFile.exists()) {
                response.respondMessage(String.format("Template %s not found.", template), 400);
                return;
            }
            if (FileUtils.deleteQuietly((File)templateFile)) {
                response.respondMessage(String.format("Template %s deleted.", template));
            } else {
                response.respondMessage(String.format("Could not delete template %s.", template), 400);
            }
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

