/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.http;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.dataset.FontDataset;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.MultipartFileParser;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.text.ESLFontLoader;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

@Route(route="/service/font")
public class FontRequestHandler
implements WebserviceRequestHandler {
    private final FontDataset fontDataset;
    private final ESLFontLoader fontLoader;

    public FontRequestHandler(FontDataset fontDataset) throws InitializationException {
        this.fontDataset = fontDataset;
        this.fontLoader = new ESLFontLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Restrict
    @Route(method=HttpRequestMethod.POST, route="upload.html")
    public void uploadFont(WebserviceRequest request, WebserviceResponse response) throws IOException, SerializeException {
        block12: {
            block11: {
                block10: {
                    block9: {
                        body = request.getBody();
                        if (!body.getContentType().getValue().contains("multipart/form-data")) break block11;
                        parser = new MultipartFileParser();
                        outputStream = null;
                        inputStream = null;
                        outputStream = new ByteArrayOutputStream();
                        fileName = parser.writeFileFromStream(body, (OutputStream)outputStream);
                        if (fileName == null) ** GOTO lbl44
                        inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                        if (!FilenameUtils.isExtension((String)fileName, (String[])new String[]{"TTF", "ttf", "OTF", "otf"})) ** GOTO lbl42
                        if (this.fontLoader.isFontValid((InputStream)inputStream)) break block9;
                        response.respondMessage(String.format("Invalid font file %s", new Object[]{fileName}), 400);
                        StreamUtils.close((OutputStream)outputStream);
                        StreamUtils.close((InputStream)inputStream);
                        return;
                    }
                    try {
                        inputStream.reset();
                        fontFile = new File(Config.getFontsPath(), fileName);
                        if (fontFile.exists()) {
                            FileUtils.deleteQuietly((File)fontFile);
                        }
                        fileOutputStream = null;
                        try {
                            fileOutputStream = new FileOutputStream(fontFile);
                            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                            this.fontDataset.reload((Transaction<?>)NoTransaction.get());
                            response.respondMessage(String.format("Font %s uploaded.", new Object[]{fontFile.getName()}));
                        }
                        catch (Throwable var10_11) {
                            StreamUtils.close(fileOutputStream);
                            throw var10_11;
                        }
                        StreamUtils.close((OutputStream)fileOutputStream);
                        break block10;
                        {
                            catch (Exception exception) {
                                response.respondMessage(String.format("Failed to store font file %s", new Object[]{fileName}), 400);
                            }
                        }
                        break block10;
lbl42:
                        // 1 sources

                        response.respondMessage(String.format("Wrong font file extension %s", new Object[]{fileName}), 400);
                        break block10;
lbl44:
                        // 1 sources

                        response.respondMessage(String.format("Could not read font file", new Object[0]), 400);
                    }
                    catch (Throwable var11_12) {
                        StreamUtils.close((OutputStream)outputStream);
                        StreamUtils.close(inputStream);
                        throw var11_12;
                    }
                }
                StreamUtils.close((OutputStream)outputStream);
                StreamUtils.close((InputStream)inputStream);
                break block12;
            }
            response.respondBadRequest();
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="delete/.*")
    public void deleteFont(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String font = StringUtils.substringAfterLast((String)request.getRequestUri().getPath(), (String)"delete/");
        if (font != null && FilenameUtils.isExtension((String)font, (String[])new String[]{"TTF", "ttf", "OTF", "otf"})) {
            File fontFile = new File(Config.getFontsPath(), new File(font).getName());
            if (!fontFile.exists()) {
                response.respondMessage(String.format("Font file %s not found.", font), 400);
                return;
            }
            if (FileUtils.deleteQuietly((File)fontFile)) {
                response.respondMessage(String.format("Font %s deleted. Restart service to complete the deletion.", font));
            } else {
                response.respondMessage(String.format("Could not delete font %s.", font), 400);
            }
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="download/.*")
    public void downloadFont(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String fontFileName = StringUtils.substringAfter((String)request.getRequestUri().getPath(), (String)"download/");
        File fontFile = new File(Config.getFontsPath(), new File(fontFileName).getName());
        if (fontFile.exists()) {
            response.respondFile(fontFile);
        } else {
            response.respondFileNotFound(String.format("Could not find font with name: %s", fontFileName));
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

