/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.http;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointUpdatePackageDataset;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdatePackageRecord;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.AccessPointUpdateInterface;
import at.mrdevelopment.esl.update.UpdatePackageMismatchException;
import at.mrdevelopment.esl.update.UpdatePackageValidator;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.HttpFormParser;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.MultipartFileParser;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Route(route="/service/updatepackage")
public class AccessPointUpdatePackageRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointUpdatePackageRequestHandler.class);
    private final AccessPointUpdateInterface accessPointUpdateInterface;
    private final AccessPointUpdatePackageDataset updatePackageDataset;
    private final AccessPointInfoDataset infoDataset;
    private final UpdatePackageValidator packageValidator;
    private final XMLToolkit xmlTookit;
    private final TransactionSupplier transactionSupplier;

    public AccessPointUpdatePackageRequestHandler(TransactionSupplier transactionSupplier, AccessPointUpdateInterface accessPointUpdateInterface, AccessPointUpdatePackageDataset updatePackageDataset, AccessPointInfoDataset infoDataset) throws InitializationException {
        this.transactionSupplier = transactionSupplier;
        this.accessPointUpdateInterface = accessPointUpdateInterface;
        this.updatePackageDataset = updatePackageDataset;
        this.infoDataset = infoDataset;
        this.packageValidator = new UpdatePackageValidator();
        this.xmlTookit = new XMLToolkit();
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="force.xml")
    public void forceSoftwareUpdate(WebserviceRequest request, WebserviceResponse response) throws SerializeException, IOException, DatasetException {
        List<AccessPointUpdatePackageRecord> updatePackages = null;
        List<AccessPointInfo> accessPointInfos = null;
        Transaction transaction = this.transactionSupplier.newTransaction();
        try {
            updatePackages = this.updatePackageDataset.queryAll(transaction);
            accessPointInfos = this.infoDataset.queryAll(transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new DatasetException((Throwable)exc);
        }
        Document document = this.toXML(updatePackages, accessPointInfos);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="forceUpdate.html")
    public void triggerForceUpdate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpFormParser formParser = new HttpFormParser(request.getBody());
        Map content = formParser.getContent();
        String checksumString = (String)content.remove("checksum");
        byte[] checksum = DatatypeConverter.parseBase64Binary((String)checksumString);
        AccessPointUpdatePackageRecord updatePackage = this.updatePackageDataset.queryByChecksum(checksum);
        if (updatePackage != null) {
            Collection accessPointIds = Collections2.transform(content.values(), (Function)new Function<String, Integer>(){

                public Integer apply(String input) {
                    return Integer.valueOf(input);
                }
            });
            if (!accessPointIds.isEmpty()) {
                logger.info("Forcing software update for %d access points.", new Object[]{accessPointIds.size()});
                Transaction transaction = this.transactionSupplier.newTransaction();
                try {
                    this.accessPointUpdateInterface.forceSoftwareUpdate(accessPointIds, updatePackage, transaction);
                    transaction.commit();
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
                response.respondMessage(String.format("Forcing update for %d access point(s)", accessPointIds.size()));
            } else {
                response.respondMessage("No access points selected.");
            }
        } else {
            logger.warn("Software update package not found");
            response.respondBadRequest();
        }
    }

    private Document toXML(List<AccessPointUpdatePackageRecord> updatePackages, List<AccessPointInfo> accessPointInfos) {
        Document document = this.xmlTookit.newDocument();
        Element root = document.createElement("ForceAccessPointSoftwareUpdate");
        document.appendChild(root);
        for (AccessPointUpdatePackageRecord updatePackage : updatePackages) {
            Element element = document.createElement("UpdatePackage");
            element.setAttribute("id", updatePackage.getId().toString());
            element.setAttribute("version", updatePackage.getUpdateVersion().toString());
            element.setAttribute("required-version", updatePackage.getRequiredVersion().toString());
            element.setAttribute("filename", updatePackage.getUpdatePackageFileName());
            element.setAttribute("type", updatePackage.getAccessPointType());
            element.setAttribute("checksum", DatatypeConverter.printBase64Binary((byte[])updatePackage.getChecksum()));
            for (AccessPointInfo accessPointInfo : accessPointInfos) {
                if (accessPointInfo.isDiscovered() || updatePackage.getAccessPointType() == null || !updatePackage.getAccessPointType().equals(accessPointInfo.getTypeIdentifier())) continue;
                Element accessPointElement = document.createElement("AccessPoint");
                accessPointElement.setAttribute("id", accessPointInfo.getAccessPointId().toString());
                element.appendChild(accessPointElement);
            }
            root.appendChild(element);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restrict
    @Route(method=HttpRequestMethod.POST, route="upload.html")
    public void uploadSoftwareUpdate(WebserviceRequest request, WebserviceResponse response) throws IOException, SerializeException {
        block15: {
            block11: {
                block12: {
                    ByteArrayInputStream inputStream;
                    ByteArrayOutputStream outputStream;
                    block10: {
                        HttpEntity body = request.getBody();
                        if (!body.getContentType().getValue().contains("multipart/form-data")) break block11;
                        String updatePackagePath = Config.getAccessPointUpdatePackagePath();
                        MultipartFileParser parser = new MultipartFileParser();
                        outputStream = null;
                        inputStream = null;
                        if (!this.isDirectoryWritableAndCreateIfNecessary(updatePackagePath)) break block12;
                        try {
                            block13: {
                                String fileName;
                                block14: {
                                    outputStream = new ByteArrayOutputStream();
                                    fileName = parser.writeFileFromStream(body, (OutputStream)outputStream);
                                    if (fileName == null) break block13;
                                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                                    if (!FilenameUtils.isExtension((String)fileName, (String[])AccessPointUpdatePackageDataset.EXTENSIONS)) break block14;
                                    try {
                                        File updateFile = new File(updatePackagePath, fileName);
                                        if (updateFile.exists()) {
                                            FileUtils.deleteQuietly((File)updateFile);
                                        }
                                        FileOutputStream fileOutputStream = null;
                                        try {
                                            fileOutputStream = new FileOutputStream(updateFile);
                                            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                                        }
                                        catch (Throwable throwable) {
                                            StreamUtils.close(fileOutputStream);
                                            throw throwable;
                                        }
                                        StreamUtils.close((OutputStream)fileOutputStream);
                                        try {
                                            this.packageValidator.validatePackage(updateFile, DeviceMode.ACCESSPOINT);
                                            this.updatePackageDataset.reload((Transaction<?>)NoTransaction.get());
                                            response.respondMessage(String.format("Update package %s uploaded.", updateFile.getName()));
                                            break block10;
                                        }
                                        catch (IOException exc) {
                                            FileUtils.deleteQuietly((File)updateFile);
                                            response.respondMessage(String.format("Failed to validate update file %s: %s", fileName, exc.getMessage()), 400);
                                            break block10;
                                        }
                                        catch (UpdatePackageMismatchException exc) {
                                            FileUtils.deleteQuietly((File)updateFile);
                                            response.respondMessage(String.format("Failed to validate update file %s: %s", exc.getMessage(), fileName), 400);
                                        }
                                    }
                                    catch (Exception exception) {
                                        response.respondMessage(String.format("Failed to store update file %s", fileName), 400);
                                    }
                                    break block10;
                                }
                                response.respondMessage(String.format("Wrong update file extension %s", fileName), 400);
                                break block10;
                            }
                            response.respondMessage(String.format("Could not read update file", new Object[0]), 400);
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close((OutputStream)outputStream);
                            StreamUtils.close(inputStream);
                            throw throwable;
                        }
                    }
                    StreamUtils.close((OutputStream)outputStream);
                    StreamUtils.close((InputStream)inputStream);
                    break block15;
                }
                response.respondMessage(String.format("Upload package path is not valid", new Object[0]), 400);
                break block15;
            }
            response.respondBadRequest();
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="delete/.*")
    public void deleteSoftwareUpdate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String updateFileName = StringUtils.substringAfterLast((String)request.getRequestUri().getPath(), (String)"delete/");
        if (updateFileName != null && FilenameUtils.isExtension((String)updateFileName, (String[])AccessPointUpdatePackageDataset.EXTENSIONS)) {
            File updateFile = new File(Config.getAccessPointUpdatePackagePath(), updateFileName);
            if (!updateFile.exists()) {
                response.respondMessage(String.format("Update package file %s not found.", updateFileName), 400);
                return;
            }
            if (FileUtils.deleteQuietly((File)updateFile)) {
                response.respondMessage(String.format("Update package file %s deleted.", updateFileName));
            } else {
                response.respondMessage(String.format("Could not delete update package %s.", updateFileName), 400);
            }
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="download/.*")
    public void downloadSoftwareUpdate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String updateFileName = StringUtils.substringAfter((String)request.getRequestUri().getPath(), (String)"download/");
        File updateFile = new File(Config.getAccessPointUpdatePackagePath(), updateFileName);
        if (updateFile.exists()) {
            response.respondFile(updateFile);
        } else {
            response.respondFileNotFound(String.format("Could not find udpate package file with name: %s", updateFileName));
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }

    private boolean isDirectoryWritableAndCreateIfNecessary(String updatePackagePath) {
        try {
            File directory = new File(updatePackagePath);
            if (directory != null) {
                if (!directory.exists()) {
                    return directory.mkdirs() && directory.canWrite();
                }
                return directory.isDirectory() && directory.canWrite();
            }
        }
        catch (Exception exception) {
            logger.warn("Update package path is not valid");
        }
        return false;
    }
}

