/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.configuration;

import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.security.Password;
import java.io.File;
import java.io.FileReader;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;

public class DefaultConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(DefaultConfiguration.class);
    private static final String USER_DEFAULTS_FILE = "config/configuration.defaults";
    private Properties properties = new Properties();

    public DefaultConfiguration() throws InitializationException {
        File configurationDefaults = new File(USER_DEFAULTS_FILE);
        if (!configurationDefaults.exists()) {
            logger.info("User configuration defaults not found, using system defaults");
            return;
        }
        try {
            this.properties.load(new FileReader(configurationDefaults));
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public Configuration getDefault(String configurationName, BasicType type, String systemDefault) {
        String userDefault = this.properties.getProperty(configurationName);
        if (userDefault == null) {
            userDefault = systemDefault;
        }
        return new Configuration(configurationName, type, systemDefault, userDefault);
    }

    public String getPasswordHash(String username, String systemDefaultPassword) throws InitializationException {
        String passwordHash = this.properties.getProperty(username + "Password");
        if (passwordHash == null) {
            try {
                passwordHash = Password.createFromPlainPassword((String)systemDefaultPassword).getSaltedHash();
            }
            catch (NoSuchAlgorithmException exc) {
                throw new InitializationException((Throwable)exc);
            }
            catch (UnsupportedEncodingException exc) {
                throw new InitializationException((Throwable)exc);
            }
        }
        return passwordHash;
    }
}

