/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.configuration;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.configuration.ConfigurationStorage;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetListener;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.Field;
import java.util.List;

public class DatabaseConfigurationStorage
extends ConfigurationStorage
implements DatasetListener<Configuration> {
    static ESLLogger logger = ESLLogger.getLogger(DatabaseConfigurationStorage.class);

    public DatabaseConfigurationStorage(ConfigurationDataset dataset) throws InitializationException {
        super(dataset);
        dataset.addDatasetListener(this);
    }

    public void init(Transaction<?> transaction) throws InitializationException {
        this.createDatabaseRecords(transaction);
    }

    @Override
    public void store(String key, BasicType type, String defaultValue, String value, Transaction<?> transaction) throws DatasetException {
        ConfigurationDataset dataset = this.getConfigurationDataset();
        try {
            Configuration configuration = dataset.getConfiguration(key, transaction);
            if (configuration == null) {
                configuration = new Configuration(key, type, defaultValue, value);
            } else {
                configuration.setKey(key);
                configuration.setType(type);
                configuration.setValue(value);
                configuration.setDefaultValue(defaultValue);
            }
            dataset.store((Commitable)configuration, UserId.SYSTEM, transaction);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    private void createDatabaseRecords(Transaction<?> transaction) throws InitializationException {
        logger.info("Importing configuration records");
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                field.setAccessible(true);
                String configurationName = field.getName();
                String systemDefault = field.get(null).toString();
                BasicType type = BasicType.fromClass(field.getType());
                Configuration configuration = this.defaultConfiguration.getDefault(configurationName, type, systemDefault);
                Configuration currentConfiguration = this.getConfigurationDataset().getConfiguration(configurationName, transaction);
                if (currentConfiguration == null) {
                    this.dataset.store((Commitable)configuration, UserId.SYSTEM, transaction);
                    continue;
                }
                boolean isDefault = currentConfiguration.isDefault();
                currentConfiguration.setDefaultValue(configuration.getDefaultValue());
                if (isDefault) {
                    currentConfiguration.setValue(configuration.getValue());
                }
                try {
                    currentConfiguration.validate();
                }
                catch (Exception exc) {
                    logger.warn("Invalid value for configuration %s: %s", new Object[]{currentConfiguration.getKey(), exc.getMessage()});
                    currentConfiguration.setValue(currentConfiguration.getDefaultValue());
                }
                this.dataset.store((Commitable)currentConfiguration, UserId.SYSTEM, transaction);
            }
            List existingConfigurations = this.dataset.queryAll(transaction);
            for (Configuration configuration : existingConfigurations) {
                this.updateFromRecord(configuration, transaction);
            }
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public void recordInsert(Configuration record, Transaction<?> transaction) throws DatasetException {
        this.updateFromRecord(record, transaction);
    }

    public void recordUpdate(Configuration record, Transaction<?> transaction) throws DatasetException {
        this.updateFromRecord(record, transaction);
    }

    public void recordDelete(Configuration record, Transaction<?> transaction) {
    }

    private ConfigurationDataset getConfigurationDataset() {
        return this.dataset;
    }
}

