/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.battery.BatteryStatusFactory;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractLabelDataCollectorJob;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.quartz.JobExecutionContext;

public class BatteryDataCollectorJob
extends AbstractLabelDataCollectorJob {
    public static final String KEY_BATTERY_STATUS_FACTORY = "batteryStatusFactory";
    static ESLLogger logger = ESLLogger.getLogger(BatteryDataCollectorJob.class);

    @Override
    protected List<Task> createTasks(Collection<LabelInfo> labelInfos, JobExecutionContext context, Transaction<?> transaction) throws Exception {
        BatteryStatusFactory batteryStatusFactory = this.getBatteryStatusFactory(context);
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (LabelInfo labelInfo : labelInfos) {
            List<Task> tasksForLabel = this.createTasks(batteryStatusFactory, labelInfo);
            if (tasksForLabel == null || tasksForLabel.isEmpty()) continue;
            tasks.addAll(tasksForLabel);
        }
        return tasks;
    }

    private List<Task> createTasks(BatteryStatusFactory batteryStatusFactory, LabelInfo labelInfo) {
        return batteryStatusFactory.createTasksForLabel(labelInfo);
    }

    private BatteryStatusFactory getBatteryStatusFactory(JobExecutionContext context) {
        if (!context.getJobDetail().getJobDataMap().containsKey((Object)KEY_BATTERY_STATUS_FACTORY)) {
            context.getJobDetail().getJobDataMap().put(KEY_BATTERY_STATUS_FACTORY, (Object)new BatteryStatusFactory());
        }
        return (BatteryStatusFactory)context.getJobDetail().getJobDataMap().get((Object)KEY_BATTERY_STATUS_FACTORY);
    }

    @Override
    protected String getTaskOrderName() {
        return "Battery Classification";
    }
}

