/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.battery.BatteryCalculationData;
import at.mrdevelopment.esl.battery.BatteryStatusFactory;
import at.mrdevelopment.esl.battery.CalculatedPowerStatus;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.LastLabelInfoHistoryForLabelQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.BatteryReplacementRecord;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.esl.persistence.record.RegisteredLabel;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class BatteryClassificationCache
implements DatasetModifiedListener<BatteryReplacementRecord> {
    static ESLLogger logger = ESLLogger.getLogger(BatteryClassificationCache.class);
    private final LabelInfoDataset labelInfoDataset;
    private final LabelInfoHistoryDataset labelInfoHistoryDataset;
    private final BatteryStatusFactory batteryStatusFactory = new BatteryStatusFactory();

    public BatteryClassificationCache(LabelInfoDataset labelInfoDataset, LabelInfoHistoryDataset labelInfoHistoryDataset) throws InitializationException {
        this.labelInfoDataset = labelInfoDataset;
        this.labelInfoHistoryDataset = labelInfoHistoryDataset;
    }

    public void init(Transaction<?> transaction) throws DatasetException {
        this.restoreFromDatabase(transaction);
    }

    private void restoreFromDatabase(Transaction<?> transaction) throws DatasetException {
        if (Config.isBatteryStatusClassificationEnabled()) {
            logger.info("Rebuilding battery status cache");
            ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
            LastLabelInfoHistoryForLabelQuery labelInfoHistoryForLabelQuery = new LastLabelInfoHistoryForLabelQuery(this.labelInfoHistoryDataset);
            QueryResult result = labelInfoHistoryForLabelQuery.getResult(QueryRestriction.newUnpagedQuery(), transaction);
            Map<LabelId, RegisteredLabel> labelRegistrations = this.labelInfoDataset.getLabelRegistration();
            for (LabelInfoHistoryRecord record : result.getRecords()) {
                RegisteredLabel labelRegistration = labelRegistrations.get(record.getLabelId());
                if (labelRegistration == null) continue;
                this.labelInfoDataset.setBatteryStatus(record.getLabelId(), new CalculatedPowerStatus(record.getCalculatedPowerStatus(), record.getCalculatedPowerStatusTimestamp()));
            }
            logger.info("Finished rebuilding battery status cache");
            timeLogger.logTime("Time for rebuilding battery status cache");
        }
    }

    public void updateCalculation(LabelInfo labelInfo, LabelDetailDataset labelDetailDataset, Transaction<?> transaction) throws DatasetException {
        logger.debug("Calculating battery status for label %s", new Object[]{labelInfo.getLabelIdString()});
        List<LabelDetail> labelDetails = labelDetailDataset.queryLabelDetailsForLabel(labelInfo.getLabelId(), DateTime.now().minusMinutes(Config.getBatteryStatusClassificationDataDurabilityMinutes()), transaction);
        if (labelDetails != null && labelDetails.size() > 0) {
            DateTime timestamp = labelDetails.get(labelDetails.size() - 1).getUpdatedAt();
            BatteryCalculationData batteryCalculationData = new BatteryCalculationData(labelInfo, timestamp, labelDetails);
            CalculatedPowerStatus batteryStatus = this.batteryStatusFactory.calculateBatteryStatusForLabel(batteryCalculationData);
            this.labelInfoDataset.setBatteryStatus(labelInfo.getLabelId(), batteryStatus);
            logger.info("New calculated battery status for label %s: %s", new Object[]{labelInfo.getLabelIdString(), batteryStatus.getPowerStatus().name()});
        } else {
            logger.info("No label data found for label %s", new Object[]{labelInfo.getLabelIdString()});
        }
    }

    public void recordsModified(Collection<BatteryReplacementRecord> records, Transaction<?> transaction) {
        if (Config.isBatteryStatusClassificationEnabled()) {
            for (BatteryReplacementRecord record : records) {
                if (record.getCommitState() != CommitState.INSERTED) continue;
                this.labelInfoDataset.setBatteryStatus(record.getLabelId(), new CalculatedPowerStatus());
            }
        }
    }
}

