/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.battery.BatteryCalculationData;
import at.mrdevelopment.esl.battery.BatteryClassificationStrategy;
import at.mrdevelopment.esl.battery.BatteryStatusFactory;
import at.mrdevelopment.esl.battery.ProductConfig;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class BatteryCalculationTest {
    private static final int DEFAULT_BATTERY_INFO = 127490;
    private static final int FREEZER_BATTERY_INFO = 127506;
    private static final int DEFAULT_TEMPERATURE = 5405;
    private static final int[] DEFAULT_LIDL_BATTERY_INFOS = new int[]{127493, 127496};

    @Test
    public void testLegacyProductConfigMapping() throws SerializeException {
        ImmutableMap values = ImmutableMap.builder().put((Object)LabelId.fromString((String)"B6000000"), (Object)ProductConfig.DEFAULT_DOUBLE).put((Object)LabelId.fromString((String)"D3000000"), (Object)ProductConfig.DEFAULT_QUADRUPLE).put((Object)LabelId.fromString((String)"F1000000"), (Object)ProductConfig.DEFAULT_SINGLE).put((Object)LabelId.fromString((String)"E5000000"), (Object)ProductConfig.DEFAULT_SEXTUPLE).build();
        for (Map.Entry entry : values.entrySet()) {
            ProductConfig config = ProductConfig.fromLegacyLabel((LabelType)((LabelId)entry.getKey()).getLabelType(), (boolean)false);
            ProductConfig expectedConfig = (ProductConfig)entry.getValue();
            Assert.assertEquals((String)String.format("Product config %s not expected (%s) for label %s", config.name(), expectedConfig.name(), entry.getKey()), (Object)config, (Object)expectedConfig);
        }
    }

    @Test
    public void testStrategySelectionStag() throws SerializeException {
        BatteryStatusFactory factory = new BatteryStatusFactory();
        LabelInfo stag = new LabelInfo(LabelId.fromString((String)"F242A09A"), null, new HashSet());
        stag.setFirmwareVersion(Version.fromString((String)"3.0.5"));
        Assert.assertEquals((Object)((Object)factory.getStrategyForLabel(stag)), (Object)((Object)BatteryClassificationStrategy.LEGACY_SINGLE_CELL));
    }

    @Test
    public void testStrategySelectionLegacy() throws SerializeException {
        BatteryStatusFactory factory = new BatteryStatusFactory();
        LabelInfo legacy = new LabelInfo(LabelId.fromString((String)"B3333333"), null, new HashSet());
        legacy.setFirmwareVersion(Version.fromString((String)"3.0.5"));
        Assert.assertEquals((Object)((Object)factory.getStrategyForLabel(legacy)), (Object)((Object)BatteryClassificationStrategy.LEGACY_MULTI_CELL));
    }

    @Test
    public void testStrategySelectionVusion() throws SerializeException {
        BatteryStatusFactory factory = new BatteryStatusFactory();
        LabelInfo legacy = new LabelInfo(LabelId.fromString((String)"B3333333"), null, new HashSet());
        legacy.setFirmwareVersion(Version.fromString((String)"3.1.1"));
        Assert.assertEquals((Object)((Object)factory.getStrategyForLabel(legacy)), (Object)((Object)BatteryClassificationStrategy.DEFAULT));
    }

    @Test
    public void testLegacyBadLabels() throws SerializeException {
        ImmutableMap values = ImmutableMap.builder().put((Object)1694, (Object)1263).put((Object)1676, (Object)1210).put((Object)1662, (Object)1263).put((Object)1670, (Object)1310).put((Object)1521, (Object)873).put((Object)1647, (Object)1138).build();
        this.validateLegacyBatteryStatus((ImmutableMap<Object, Object>)values, BatteryClassificationStrategy.LEGACY_MULTI_CELL, PowerStatus.BAD, 5405);
    }

    @Test
    public void testLegacyGoodLabels() throws SerializeException {
        ImmutableMap values = ImmutableMap.builder().put((Object)1667, (Object)642).put((Object)1670, (Object)937).put((Object)1726, (Object)1177).put((Object)1688, (Object)1046).put((Object)1675, (Object)996).put((Object)1697, (Object)1110).put((Object)1677, (Object)987).put((Object)1655, (Object)882).put((Object)1694, (Object)973).put((Object)1693, (Object)1082).put((Object)1651, (Object)937).put((Object)1536, (Object)626).put((Object)1531, (Object)673).put((Object)1526, (Object)598).put((Object)1659, (Object)784).put((Object)1676, (Object)859).put((Object)1665, (Object)720).put((Object)1719, (Object)985).put((Object)1672, (Object)745).put((Object)1682, (Object)843).put((Object)1671, (Object)628).put((Object)1658, (Object)667).put((Object)1662, (Object)684).put((Object)1678, (Object)720).put((Object)1710, (Object)865).put((Object)1711, (Object)601).put((Object)1696, (Object)583).put((Object)1700, (Object)912).build();
        this.validateLegacyBatteryStatus((ImmutableMap<Object, Object>)values, BatteryClassificationStrategy.LEGACY_MULTI_CELL, PowerStatus.GOOD, 5405);
    }

    @Test
    public void testFreezerBadLabels() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-1197303204, -1327400352, -1172211120, -1256195516, -1386235332, -1411401168, -1344308664, -1247839652, -1411446188, -1403065776, -1361130936, -1453409724, -1352754624});
        this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.BAD, 127506);
    }

    @Test
    public void testFreezerGoodLabels() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-554297064});
        this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.GOOD, 127506);
    }

    @Test
    public void testDefaultUnknownLabels() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-1218193132, -1432450792, -554297064});
        this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.UNKNOWN, 127490);
    }

    @Test
    public void testDefaultBadLabels() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-1218192812, -1218192812, -1197303204, -1327400352, -1172211120, -1256195516, -1386235332, -1411401168, -1344308664, -1247839652, -1411446188, -1403065776, -1361130936, -1453409724, -1352754624, -1394697664, -1432450488, -1323398580, -1466013116, -1436706232});
        this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.BAD, 127490);
    }

    @Test
    public void testDefaultLowLabels() {
        ArrayList values = Lists.newArrayList();
        this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.LOW, 127490);
    }

    @Test
    public void testDefaultGoodLabels() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-928474544, -928515520, -1125615016, -554280372, -1083696544, -1054303656, -1075266972, -554284468, -550086064, -554292660, -554272180, -924263864, -1020749228, -558474680, -554280372, -558470580, -558478772, -558466484, -554296760, -558474676, -558474676, -562668976, -562668980, -562673080, -558474676, -562677176, -558482868});
        this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.GOOD, 127490);
    }

    @Test
    public void testSTagsBad() throws SerializeException {
        ImmutableMap values = ImmutableMap.builder().put((Object)1425, (Object)934).put((Object)1393, (Object)787).put((Object)1474, (Object)726).put((Object)1442, (Object)795).put((Object)1376, (Object)1177).build();
        this.validateLegacyBatteryStatus((ImmutableMap<Object, Object>)values, BatteryClassificationStrategy.LEGACY_SINGLE_CELL, PowerStatus.BAD, 5405);
    }

    @Test
    public void testSTagsLow() throws SerializeException {
        ImmutableMap values = ImmutableMap.builder().put((Object)1551, (Object)520).put((Object)1513, (Object)954).put((Object)1507, (Object)1408).put((Object)1556, (Object)520).put((Object)1540, (Object)609).build();
        this.validateLegacyBatteryStatus((ImmutableMap<Object, Object>)values, BatteryClassificationStrategy.LEGACY_SINGLE_CELL, PowerStatus.LOW, 5405);
    }

    @Test
    public void testSTagsGood() throws SerializeException {
        ImmutableMap values = ImmutableMap.builder().put((Object)1600, (Object)1026).put((Object)1666, (Object)233).put((Object)1671, (Object)242).put((Object)1617, (Object)350).put((Object)1649, (Object)665).build();
        this.validateLegacyBatteryStatus((ImmutableMap<Object, Object>)values, BatteryClassificationStrategy.LEGACY_SINGLE_CELL, PowerStatus.GOOD, 5405);
    }

    @Test
    public void testLidlGood() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-554280372, -550086064, -554292660, -554272180, -558470580, -558478772, -558466484, -554296760, -558474676, -558474676, -562668976, -562668980, -562673080});
        for (int batteryInfo : DEFAULT_LIDL_BATTERY_INFOS) {
            this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.GOOD, batteryInfo);
        }
    }

    @Test
    public void testLidlBad() {
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{-1218192812, -1218192812, -1197303204, -1327400352, -1172211120, -1256195516, -1386235332, -1411401168, -1344308664, -1247839652, -1411446188, -1403065776, -1361130936, -1453409724, -1352754624, -1394697664, -1432450488, -1323398580, -1466013116, -1436706232});
        for (int batteryInfo : DEFAULT_LIDL_BATTERY_INFOS) {
            this.validateBatteryStatus(values, BatteryClassificationStrategy.DEFAULT, PowerStatus.BAD, batteryInfo);
        }
    }

    private void validateBatteryStatus(List<Integer> values, BatteryClassificationStrategy strategy, PowerStatus expectedPowerStatus, int batteryInfo) {
        for (Integer batterySample : values) {
            BatteryCalculationData data = this.createDefaultData(batterySample, batteryInfo);
            PowerStatus powerStatus = strategy.calculateBatteryStatus(data);
            if (powerStatus != expectedPowerStatus) {
                System.out.format("%s (%s), %08X%n", powerStatus.name(), expectedPowerStatus.name(), batterySample);
            }
            Assert.assertEquals((String)String.format("Expected calculated power status to be %s but was actually: %s (%02X)", expectedPowerStatus.name(), powerStatus.name(), batterySample), (Object)expectedPowerStatus, (Object)powerStatus);
        }
    }

    private void validateLegacyBatteryStatus(ImmutableMap<Object, Object> values, BatteryClassificationStrategy strategy, PowerStatus expectedPowerStatus, int temperature) throws SerializeException {
        for (Map.Entry entry : values.entrySet()) {
            BatteryCalculationData data = this.createLegacyData((Integer)entry.getKey(), (Integer)entry.getValue(), temperature);
            PowerStatus powerStatus = strategy.calculateBatteryStatus(data);
            if (powerStatus != expectedPowerStatus) {
                System.out.format("%s (%s), %s, %s%n", powerStatus.name(), expectedPowerStatus.name(), entry.getKey(), entry.getValue());
            }
            Assert.assertEquals((String)String.format("Expected calculated power status to be %s but was actually: %s", expectedPowerStatus.name(), powerStatus.name()), (Object)expectedPowerStatus, (Object)powerStatus);
        }
    }

    private BatteryCalculationData createLegacyData(int mcuVoltage, int resistance, int temperature) throws SerializeException {
        LabelDetail mcu = new LabelDetail();
        mcu.setType(LabelDetailType.QUERY_SENSOR);
        mcu.setDataId(Integer.valueOf(LabelSensor.MCU_SUPPLY_VOLTAGE_SENSOR.getSensorId()));
        mcu.setValue(Integer.valueOf(mcuVoltage));
        LabelDetail res = new LabelDetail();
        res.setType(LabelDetailType.QUERY_SENSOR);
        res.setDataId(Integer.valueOf(LabelSensor.BATTERY_RESISTANCE_SENSOR.getSensorId()));
        res.setValue(Integer.valueOf(resistance));
        LabelDetail temp = new LabelDetail();
        temp.setType(LabelDetailType.QUERY_SENSOR);
        temp.setDataId(Integer.valueOf(LabelSensor.TEMPERATURE_SENSOR.getSensorId()));
        temp.setValue(Integer.valueOf(temperature));
        LabelInfo labelInfo = new LabelInfo(LabelId.fromString((String)"B3000000"), null, new HashSet());
        return new BatteryCalculationData(labelInfo, DateTime.now(), Lists.newArrayList((Object[])new LabelDetail[]{mcu, res, temp}));
    }

    private BatteryCalculationData createDefaultData(int batterySample, int batteryInfo) {
        LabelDetail data = new LabelDetail();
        data.setType(LabelDetailType.GET_CONFIG);
        data.setDataId(Integer.valueOf(LabelConfig.BATTERY_MEASUREMENT_SAMPLE.getConfigId()));
        data.setValue(Integer.valueOf(batterySample));
        LabelDetail info = new LabelDetail();
        info.setType(LabelDetailType.GET_CONFIG);
        info.setDataId(Integer.valueOf(LabelConfig.BATTERY_MEASUREMENT_INFO.getConfigId()));
        info.setValue(Integer.valueOf(batteryInfo));
        return new BatteryCalculationData(null, DateTime.now(), Lists.newArrayList((Object[])new LabelDetail[]{data, info}));
    }
}

