/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import java.util.List;
import org.joda.time.DateTime;

public class BatteryCalculationData {
    private final LabelInfo labelInfo;
    private final DateTime timestamp;
    private final List<LabelDetail> labelDetails;

    public BatteryCalculationData(LabelInfo labelInfo, DateTime timestamp, List<LabelDetail> labelDetails) {
        this.labelInfo = labelInfo;
        this.timestamp = timestamp;
        this.labelDetails = labelDetails;
    }

    public LabelInfo getLabelInfo() {
        return this.labelInfo;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public List<LabelDetail> getLabelData() {
        return this.labelDetails;
    }

    private Integer getValue(LabelDetailType type, int dataId) {
        for (LabelDetail record : this.labelDetails) {
            if (type != record.getType() || record.getDataId() != dataId) continue;
            return record.getValue();
        }
        return null;
    }

    public Integer getRawValue(LabelSensor labelSensor) {
        return this.getValue(LabelDetailType.QUERY_SENSOR, labelSensor.getSensorId());
    }

    public Integer getValue(LabelCounter labelCounter) {
        return this.getValue(LabelDetailType.QUERY_COUNTER, labelCounter.getCounterId());
    }

    public Integer getValue(LabelConfig labelConfig) {
        return this.getValue(LabelDetailType.GET_CONFIG, labelConfig.getConfigId());
    }
}

