/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.authentication;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.dataset.UserDataset;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class UserAuthenticator
implements Authenticator {
    static ESLLogger logger = ESLLogger.getLogger(UserAuthenticator.class);
    private final UserDataset userDataset;
    private final boolean checkApiAccess;
    private final TransactionSupplier transactionSupplier;

    public UserAuthenticator(TransactionSupplier transactionSupplier, UserDataset userDataset) {
        this(transactionSupplier, userDataset, false);
    }

    public UserAuthenticator(TransactionSupplier transactionSupplier, UserDataset userDataset, boolean checkApiAccess) {
        this.transactionSupplier = transactionSupplier;
        this.userDataset = userDataset;
        this.checkApiAccess = checkApiAccess;
    }

    public UserId authorize(String username, String password) {
        try {
            Transaction transaction = this.transactionSupplier.newTransaction();
            try {
                User user = this.queryUser(username, transaction);
                transaction.commit();
                if (user != null && (this.checkApiAccess && user.getApiAccess().booleanValue() || !this.checkApiAccess) && user.getAuthenticationUser().getPassword().verify(password)) {
                    return user;
                }
            }
            catch (Exception exc) {
                transaction.rollback();
                logger.logException((Throwable)exc);
            }
        }
        catch (DatasetException exc) {
            logger.warn("Could not validate authentication: %s", new Object[]{exc.getMessage()});
            logger.logException((Throwable)exc);
        }
        return UserId.NONE;
    }

    private User queryUser(String username, Transaction<?> transaction) throws DatasetException {
        try {
            User user = this.userDataset.queryByUsername(username, transaction);
            return user;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }
}

