/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.authentication;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.dataset.UserDataset;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;

public class TokenAuthenticator {
    static ESLLogger logger = ESLLogger.getLogger(TokenAuthenticator.class);
    private final UserDataset userDataset;
    private final TransactionSupplier transactionSupplier;

    public TokenAuthenticator(TransactionSupplier transactionSupplier, UserDataset userDataset) {
        this.transactionSupplier = transactionSupplier;
        this.userDataset = userDataset;
    }

    public UserId authorize(String token) {
        try {
            Transaction transaction = this.transactionSupplier.newTransaction();
            try {
                List users = this.userDataset.queryAll(transaction);
                transaction.commit();
                for (User user : users) {
                    String userToken = user.getApiToken();
                    if (token == null || userToken == null || userToken.isEmpty() || !token.equals(userToken)) continue;
                    return user.getApiAccess() != null && user.getApiAccess() != false ? user : this.unauthorizedUser(user);
                }
            }
            catch (Exception exc) {
                transaction.rollback();
                logger.logException((Throwable)exc);
            }
        }
        catch (DatasetException exc) {
            logger.warn("Could not validate token credentials: %s", new Object[]{exc.getMessage()});
            logger.logException((Throwable)exc);
        }
        return UserId.NONE;
    }

    private UserId unauthorizedUser(final User user) {
        return new UserId(){

            public boolean isAuthorized() {
                return false;
            }

            public String getUsername() {
                return user.getUsername();
            }

            public Role getRole() {
                return user.getRole();
            }

            public Long getId() {
                return user.getId();
            }
        };
    }
}

