/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.server.http.ESLServiceHttpServer;
import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.http.BasicHttpServer;
import at.mrdevelopment.toolkit.http.WebserviceException;
import java.util.List;

public class IntegratedThinAPWebServerConfiguration
implements ThinAccessPointWebServerConfiguration {
    private final int accessPointId;
    private final ESLServiceHttpServer eslHttpServer;
    private final int listenPort;
    private List<BasicHttpRequestHandler> handlers;

    public IntegratedThinAPWebServerConfiguration(int accessPointId, ESLServiceHttpServer eslHttpServer, int listenPort) {
        this.accessPointId = accessPointId;
        this.eslHttpServer = eslHttpServer;
        this.listenPort = listenPort;
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public ServiceAddress createServiceAddress(boolean ssl, String ipAddress) {
        return new ServiceAddress(ssl, ipAddress, this.listenPort, this.getPrefix() + "/");
    }

    public void startServer(BasicHttpServer httpServer) throws WebserviceException {
        this.handlers = httpServer.getRegistry().getHandlers();
        for (int index = this.handlers.size() - 1; index >= 0; --index) {
            BasicHttpRequestHandler handler = this.handlers.get(index);
            handler.addPathPrefix(this.getPrefix());
            this.eslHttpServer.registerInFront(handler);
        }
    }

    public void stopServer(BasicHttpServer httpServer) {
        List tempHandlers = httpServer.getRegistry().getHandlers();
        for (BasicHttpRequestHandler requestHandler : tempHandlers) {
            this.eslHttpServer.unregister(requestHandler);
        }
    }

    private String getPrefix() {
        return String.format("/ap/%d", this.getAccessPointId());
    }

    public String toString() {
        return String.format("integrated for AP %d", this.getAccessPointId());
    }

    public void shutdown() {
        for (BasicHttpRequestHandler handler : this.handlers) {
            this.eslHttpServer.unregister(handler);
        }
    }
}

