/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceController;
import at.mrdevelopment.esl.accesspoint.IntegratedThinAPWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.ServerTCPAPSettings;
import at.mrdevelopment.esl.accesspoint.TCPAccessPoint;
import at.mrdevelopment.esl.accesspoint.UDPAccessPoint;
import at.mrdevelopment.esl.accesspoint.USBAccessPointService;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointInfoHolder;
import at.mrdevelopment.esl.accesspoint.controller.StandaloneThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.ThinAccessPointWebServerConfiguration;
import at.mrdevelopment.esl.accesspoint.controller.tcp.TCPAccessPointController;
import at.mrdevelopment.esl.accesspoint.controller.udp.UDPAccessPointController;
import at.mrdevelopment.esl.accesspoint.taskqueue.ImpreciseDateTimeProvider;
import at.mrdevelopment.esl.accesspoint.tcp.TCPAccessPointSettings;
import at.mrdevelopment.esl.accesspoint.usb.USBAccessPoint;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.certificate.ESLKeyManagerFactory;
import at.mrdevelopment.esl.certificate.ESLTrustManager;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.http.ESLServiceHttpServer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpServiceClientConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.extern.DefaultTCPTLSConfiguration;
import at.mrdevelopment.toolkit.tcp.extern.TCPTLSConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AccessPointControllerManager
implements AccessPointServiceController {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointControllerManager.class);
    private static final int DEFAULT_USB_BAUDRATE = 230400;
    private final TCPAccessPointController tcpAccessPointController;
    private final UDPAccessPointController udpAccessPointController;
    private final Map<Integer, Integer> thinAPPorts = new HashMap<Integer, Integer>();
    private final Map<Integer, ConfigControllerTypePair> thinAPConfigurations = new HashMap<Integer, ConfigControllerTypePair>();
    private final ESLServiceHttpServer httpServer;
    private final int listenPort;
    private final boolean useSSL;
    private USBAccessPointService usbAccessPointService;

    public AccessPointControllerManager(ESLServiceHttpServer httpServer, int httpListenPort, AccessPointInfoDataset infoDataset, boolean useSSL) throws InitializationException {
        this.httpServer = httpServer;
        this.listenPort = httpListenPort;
        this.useSSL = useSSL;
        ImpreciseDateTimeProvider.createAndStart((int)5);
        this.udpAccessPointController = new UDPAccessPointController(true, Config.getLancomInitialLocalPort(), Config.getLancomLastLocalPort(), (AccessPointInfoHolder)infoDataset);
        TrustManager[] trustManagers = new TrustManager[]{new ESLTrustManager(Config.isTlsStrictVerification(), Config.isTlsVerifyClientCertificates())};
        this.tcpAccessPointController = new TCPAccessPointController(true, (TCPAccessPointSettings)new ServerTCPAPSettings(), (TCPTLSConfiguration)new DefaultTCPTLSConfiguration(new ESLKeyManagerFactory().getKeyManagers(), trustManagers));
        this.usbAccessPointService = null;
    }

    @Override
    public ServiceAddress getServiceAddress(int accessPointId, ServiceAddress serviceAddress, boolean thinModeEnabled) {
        AccessPointType type = AccessPointTypeMapping.getType((int)accessPointId);
        if (type.useThinApController() || (type == AccessPointType.IMAGOTAG || type == AccessPointType.USB_AP || type == AccessPointType.SIMULATED) && thinModeEnabled) {
            return this.getThinAPServiceAddress(accessPointId, serviceAddress);
        }
        if (type == AccessPointType.USB_AP) {
            return this.getUSBAPServiceAddress(accessPointId, serviceAddress);
        }
        return serviceAddress;
    }

    @Override
    public ServiceAddress getManagementAddress(int accessPointId, ServiceAddress serviceAddress) {
        AccessPointType type = AccessPointTypeMapping.getType((int)accessPointId);
        if (type == AccessPointType.LANCOM) {
            return new ServiceAddress(serviceAddress.useSSL(), serviceAddress.getHost(), 80);
        }
        if (type == AccessPointType.USB_AP) {
            return this.getUSBAPServiceAddress(accessPointId, serviceAddress);
        }
        return serviceAddress;
    }

    @Override
    public AccessPointService createAccessPointService(int accessPointId, ServiceAddress serviceAddress, boolean isPermanentlyOffline, boolean isThinModeEnabled) throws InitializationException {
        String remoteAddress;
        int remotePort;
        int port;
        ServiceAddress thinAPServiceAddress;
        AccessPointType type = AccessPointTypeMapping.getType((int)accessPointId);
        if (type == AccessPointType.USB_AP && !isThinModeEnabled) {
            return this.createUSBAccessPointService(accessPointId, serviceAddress, this.getWebServerConfiguration(8080, accessPointId));
        }
        if (type.supportsThinAp()) {
            thinAPServiceAddress = this.getThinAPServiceAddress(accessPointId, serviceAddress);
            port = thinAPServiceAddress.getPort();
            remotePort = serviceAddress.getPort();
            remoteAddress = serviceAddress.getHost();
            if (Config.isAccessPointControllerEnabled()) {
                if (type == AccessPointType.LANCOM && !isThinModeEnabled || type == AccessPointType.SIMULATED_THIN_AP) {
                    ThinAccessPointConfiguration configuration = new ThinAccessPointConfiguration(accessPointId, this.getWebServerConfiguration(port, accessPointId), remoteAddress, remotePort, isPermanentlyOffline);
                    return this.innerCreateAccessPointService((AccessPointController)this.udpAccessPointController, accessPointId, configuration);
                }
                if (isThinModeEnabled && type == AccessPointType.SIMULATED) {
                    ThinAccessPointConfiguration configuration = new ThinAccessPointConfiguration(accessPointId, this.getWebServerConfiguration(port, accessPointId), remoteAddress, remotePort, false);
                    return this.innerCreateAccessPointService((AccessPointController)this.tcpAccessPointController, accessPointId, configuration);
                }
            }
        }
        if (isThinModeEnabled && (type == AccessPointType.IMAGOTAG || type == AccessPointType.USB_AP || type == AccessPointType.SIMULATED || type == AccessPointType.LANCOM)) {
            thinAPServiceAddress = this.getThinAPServiceAddress(accessPointId, serviceAddress);
            port = thinAPServiceAddress.getPort();
            remotePort = serviceAddress.getPort();
            remoteAddress = serviceAddress.getHost();
            ThinAccessPointConfiguration configuration = new ThinAccessPointConfiguration(accessPointId, this.getWebServerConfiguration(port, accessPointId), remoteAddress, remotePort, false);
            return this.innerCreateAccessPointService((AccessPointController)this.tcpAccessPointController, accessPointId, configuration);
        }
        logger.debug("Creating service client for thick AP %d", new Object[]{accessPointId});
        return new AccessPointServiceClient(accessPointId, serviceAddress, this.getHttpConfiguration());
    }

    private AccessPointService createUSBAccessPointService(int accessPointId, ServiceAddress serviceAddress, ThinAccessPointWebServerConfiguration webServerConfiguration) throws InitializationException {
        if (this.usbAccessPointService != null) {
            throw new InitializationException("Only one USB access point instance allowed", new Object[0]);
        }
        try {
            ServiceAddress usbServiceAddress = this.getUSBAPServiceAddress(accessPointId, serviceAddress);
            this.usbAccessPointService = new USBAccessPointService(usbServiceAddress, new USBAccessPoint(Config.getUsbAccessPointSerialPort(), 230400, AccessPointType.USB_AP.getDefaultPort(), accessPointId, Integer.valueOf(Config.getUsbAccessPointChannel()), "data/firmware/firmware.xml", webServerConfiguration));
            return this.usbAccessPointService;
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private AccessPointService innerCreateAccessPointService(AccessPointController controller, int accessPointId, ThinAccessPointConfiguration configuration) throws InitializationException {
        if (!controller.isRunning(configuration)) {
            controller.addAccessPoint(configuration);
            logger.debug("Creating service client for thin AP %d", new Object[]{accessPointId});
            if (controller instanceof UDPAccessPointController) {
                this.thinAPConfigurations.put(accessPointId, new ConfigControllerTypePair(configuration, AccessPointControllerType.UDP));
                return ((UDPAccessPoint)((UDPAccessPointController)controller).getModel().getAccessPoint(configuration)).getAccessPointService();
            }
            this.thinAPConfigurations.put(accessPointId, new ConfigControllerTypePair(configuration, AccessPointControllerType.TCP));
            return ((TCPAccessPoint)((TCPAccessPointController)controller).getModel().getAccessPoint(configuration)).getAccessPointService();
        }
        throw new InitializationException("Cannot start access point controller instance for access point %d. An instance for address %s is already running.", new Object[]{accessPointId, configuration.getRemoteAddress()});
    }

    private ThinAccessPointWebServerConfiguration getWebServerConfiguration(int port, int accessPointId) {
        if (Config.isAccessPointControllerIntegratedWebservice()) {
            return new IntegratedThinAPWebServerConfiguration(accessPointId, this.httpServer, this.listenPort);
        }
        return new StandaloneThinAccessPointWebServerConfiguration(port);
    }

    @Override
    public HttpServiceClientConfiguration getHttpConfiguration() throws InitializationException {
        return HttpServiceClientConfiguration.createConfiguration(null, (X509TrustManager)new ESLTrustManager(Config.isSslStrictVerification(), Config.isSslClientCertificates()), (KeyManager[])new ESLKeyManagerFactory().getKeyManagers(), (boolean)Config.isSslHostnameVerification());
    }

    private ServiceAddress getThinAPServiceAddress(int accessPointId, ServiceAddress serviceAddress) {
        if (Config.isAccessPointControllerIntegratedWebservice()) {
            return new ServiceAddress(this.useSSL, this.getAccessPointControllerHostname(), this.listenPort, "admin", Config.getAccessPointAdministrationPassword(), String.format("/ap/%d/", accessPointId));
        }
        return new ServiceAddress(this.useSSL, this.getAccessPointControllerHostname(), this.getServicePortForThinAP(accessPointId, serviceAddress), "admin", Config.getAccessPointAdministrationPassword());
    }

    private ServiceAddress getUSBAPServiceAddress(int accessPointId, ServiceAddress serviceAddress) {
        if (Config.isAccessPointControllerIntegratedWebservice()) {
            return new ServiceAddress(this.useSSL, this.getAccessPointControllerHostname(), this.listenPort, "admin", Config.getAccessPointAdministrationPassword(), String.format("/ap/%d/", accessPointId));
        }
        return new ServiceAddress(this.useSSL, this.getAccessPointControllerHostname(), this.getServicePortForThinAP(accessPointId, serviceAddress), "admin", Config.getAccessPointAdministrationPassword());
    }

    private String getAccessPointControllerHostname() {
        if (Config.getAccessPointControllerHostname().equals("localhost")) {
            try {
                return new EnvironmentProperties(false, true, true, true).getIPAddress();
            }
            catch (InitializationException exc) {
                logger.debug("Could not parse hostname for access point service instance: %s", new Object[]{exc.getMessage()});
            }
        }
        return Config.getAccessPointControllerHostname();
    }

    private int getServicePortForThinAP(int accessPointId, ServiceAddress serviceAddress) {
        if (!this.thinAPPorts.containsKey(accessPointId)) {
            for (int port = Config.getAccessPointControllerFirstPort(); port <= Config.getAccessPointControllerFirstPort() + this.thinAPPorts.size(); ++port) {
                boolean portFound = false;
                portFound = this.thinAPPorts.containsValue(port);
                if (portFound) continue;
                this.thinAPPorts.put(accessPointId, port);
                return port;
            }
        }
        return this.thinAPPorts.get(accessPointId);
    }

    @Override
    public void removeAccessPoint(int accessPointId) {
        AccessPointType type = AccessPointTypeMapping.getType((int)accessPointId);
        if (type.isUdp()) {
            this.innerRemoveAccessPoint(accessPointId);
        } else if (type == AccessPointType.USB_AP) {
            if (this.usbAccessPointService != null) {
                this.usbAccessPointService.shutdown();
                this.usbAccessPointService = null;
            } else {
                this.innerRemoveAccessPoint(accessPointId);
            }
        } else {
            this.innerRemoveAccessPoint(accessPointId);
        }
    }

    private void innerRemoveAccessPoint(int accessPointId) {
        ConfigControllerTypePair pair = this.thinAPConfigurations.get(accessPointId);
        if (pair != null) {
            if (this.thinAPPorts.containsKey(accessPointId)) {
                this.thinAPPorts.remove(accessPointId);
            }
            if (pair.type == AccessPointControllerType.UDP) {
                this.udpAccessPointController.removeAccessPoint(pair.config);
                this.thinAPConfigurations.remove(accessPointId);
            } else {
                this.tcpAccessPointController.removeAccessPoint(pair.config);
                this.thinAPConfigurations.remove(accessPointId);
            }
        }
    }

    public void shutdown() {
        logger.info("Shutting down access point controller");
        this.udpAccessPointController.shutdown();
        this.tcpAccessPointController.shutdown();
        if (this.usbAccessPointService != null) {
            this.usbAccessPointService.shutdown();
        }
        ImpreciseDateTimeProvider.getInstance().shutdown();
    }

    public class ConfigControllerTypePair {
        private final ThinAccessPointConfiguration config;
        private final AccessPointControllerType type;

        public ConfigControllerTypePair(ThinAccessPointConfiguration config, AccessPointControllerType type) {
            this.config = config;
            this.type = type;
        }

        public ThinAccessPointConfiguration getConfig() {
            return this.config;
        }

        public AccessPointControllerType getType() {
            return this.type;
        }
    }

    public static enum AccessPointControllerType {
        UDP,
        TCP;

    }
}

