/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.linked;

import gnu.trove.list.TLinkable;
import gnu.trove.list.linked.TLinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class ModifiedTroveIteratorImpl<T extends TLinkable<T>>
implements ListIterator<T> {
    private TLinkedList<T> list;
    private int _nextIndex = 0;
    private T _next;
    private T _lastReturned;

    public void init(TLinkedList<T> newList) {
        this.list = newList;
        this._nextIndex = 0;
        this._next = this.list._head;
    }

    @Override
    public final void add(T linkable) {
        this._lastReturned = null;
        ++this._nextIndex;
        if (this.list._size == 0) {
            this.list.add(linkable);
        } else {
            this.list.addBefore(this._next, linkable);
        }
    }

    @Override
    public final boolean hasNext() {
        return this._nextIndex != this.list._size;
    }

    @Override
    public final boolean hasPrevious() {
        return this._nextIndex != 0;
    }

    @Override
    public final T next() {
        if (this._nextIndex == this.list._size) {
            throw new NoSuchElementException();
        }
        this._lastReturned = this._next;
        this._next = this._next.getNext();
        ++this._nextIndex;
        return this._lastReturned;
    }

    @Override
    public final int nextIndex() {
        return this._nextIndex;
    }

    @Override
    public final T previous() {
        if (this._nextIndex == 0) {
            throw new NoSuchElementException();
        }
        if (this._nextIndex == this.list._size) {
            this._next = this.list._tail;
            this._lastReturned = this._next;
        } else {
            this._next = this._next.getPrevious();
            this._lastReturned = this._next;
        }
        --this._nextIndex;
        return this._lastReturned;
    }

    @Override
    public final int previousIndex() {
        return this._nextIndex - 1;
    }

    @Override
    public final void remove() {
        if (this._lastReturned == null) {
            throw new IllegalStateException("must invoke next or previous before invoking remove");
        }
        if (this._lastReturned != this._next) {
            --this._nextIndex;
        }
        this._next = this._lastReturned.getNext();
        this.list.remove(this._lastReturned);
        this._lastReturned = null;
    }

    @Override
    public final void set(T linkable) {
        if (this._lastReturned == null) {
            throw new IllegalStateException();
        }
        this.swap(this._lastReturned, linkable);
        this._lastReturned = linkable;
    }

    private void swap(T from, T to) {
        TLinkable from_p = from.getPrevious();
        TLinkable from_n = from.getNext();
        TLinkable to_p = to.getPrevious();
        TLinkable to_n = to.getNext();
        if (from_n == to) {
            if (from_p != null) {
                from_p.setNext(to);
            }
            to.setPrevious(from_p);
            to.setNext(from);
            from.setPrevious(to);
            from.setNext(to_n);
            if (to_n != null) {
                to_n.setPrevious(from);
            }
        } else if (to_n == from) {
            if (to_p != null) {
                to_p.setNext(to);
            }
            to.setPrevious(from);
            to.setNext(from_n);
            from.setPrevious(to_p);
            from.setNext(to);
            if (from_n != null) {
                from_n.setPrevious(to);
            }
        } else {
            from.setNext(to_n);
            from.setPrevious(to_p);
            if (to_p != null) {
                to_p.setNext(from);
            }
            if (to_n != null) {
                to_n.setPrevious(from);
            }
            to.setNext(from_n);
            to.setPrevious(from_p);
            if (from_p != null) {
                from_p.setNext(to);
            }
            if (from_n != null) {
                from_n.setPrevious(to);
            }
        }
        if (this.list._head == from) {
            this.list._head = to;
        } else if (this.list._head == to) {
            this.list._head = from;
        }
        if (this.list._tail == from) {
            this.list._tail = to;
        } else if (this.list._tail == to) {
            this.list._tail = from;
        }
        if (this._lastReturned == from) {
            this._lastReturned = to;
        } else if (this._lastReturned == to) {
            this._lastReturned = from;
        }
        if (this._next == from) {
            this._next = to;
        } else if (this._next == to) {
            this._next = from;
        }
    }
}

