/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.xml.sax;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.sax.SAXContentHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SAXXMLToolkit {
    static ESLLogger logger = ESLLogger.getLogger(SAXXMLToolkit.class);
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final Schema schema;
    private final ErrorHandler errorHandler = new LoggingErrorHandler();
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public SAXXMLToolkit() throws InitializationException {
        this(null);
    }

    public SAXXMLToolkit(String xsdSchemaFilename) throws InitializationException {
        this.parserFactory.setNamespaceAware(true);
        this.schema = this.createSchema(xsdSchemaFilename);
    }

    private Schema createSchema(String xsdSchemaFilename) throws InitializationException {
        if (xsdSchemaFilename != null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            InputStream xsdStream = SAXXMLToolkit.class.getResourceAsStream("/xsd/" + xsdSchemaFilename);
            StreamSource schemaFile = new StreamSource(xsdStream);
            try {
                return schemaFactory.newSchema(schemaFile);
            }
            catch (SAXException exc) {
                throw new InitializationException(exc, "Failed loading '%s'", xsdSchemaFilename);
            }
        }
        return null;
    }

    public <V extends SAXContentHandler<?>> void parseXML(File xmlFile, V contentHandler) throws FileNotFoundException, SerializeException {
        this.parseXML(new InputSource(new FileReader(xmlFile)), contentHandler);
    }

    public <V extends SAXContentHandler<?>> void parseXML(InputStream xmlInputStream, V contentHandler) throws SerializeException {
        this.parseXML(new InputSource(xmlInputStream), contentHandler);
    }

    public <V extends SAXContentHandler<?>> void parseXML(InputSource inputSource, V contentHandler) throws SerializeException {
        XMLReader xmlReader = this.createReader();
        xmlReader.setContentHandler(contentHandler);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw new SerializeException(exc);
        }
        catch (SAXException exc) {
            throw new SerializeException(exc);
        }
    }

    private XMLReader createReader() throws SerializeException {
        try {
            SAXParser saxParser = this.parserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(this.errorHandler);
            return xmlReader;
        }
        catch (ParserConfigurationException exc) {
            throw new SerializeException(exc, "Failed to load SAX XML parser/reader", new Object[0]);
        }
        catch (SAXException exc) {
            throw new SerializeException(exc, "Failed to load SAX XML parser/reader", new Object[0]);
        }
    }

    public void validate(Source source) throws SerializeException {
        try {
            if (this.schema != null) {
                Validator validator = this.schema.newValidator();
                validator.setErrorHandler(this.errorHandler);
                validator.validate(source);
            }
        }
        catch (SAXException exc) {
            throw new SerializeException(exc);
        }
        catch (IOException exc) {
            throw new SerializeException(exc);
        }
    }

    private static class LoggingErrorHandler
    implements ErrorHandler {
        private LoggingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            logger.warn(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            logger.error(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            logger.error(exception.getMessage());
        }
    }
}

