/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.xml;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.TransformerErrorListener;
import at.mrdevelopment.toolkit.xml.UnicodeBOMInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLToolkit {
    static ESLLogger logger = ESLLogger.getLogger(XMLToolkit.class);
    private final DocumentBuilder documentBuilder;
    private final Schema schema;
    private final ErrorHandler errorHandler = new LoggingErrorHandler();
    private final boolean disableExternalEntities;

    public XMLToolkit() throws InitializationException {
        this(null, false);
    }

    public XMLToolkit(boolean disableExternalEntities) throws InitializationException {
        this(null, disableExternalEntities);
    }

    public XMLToolkit(String xsdSchemaFilename) throws InitializationException {
        this(xsdSchemaFilename, false);
    }

    public XMLToolkit(String xsdSchemaFilename, boolean disableExternalEntities) throws InitializationException {
        try {
            this.disableExternalEntities = disableExternalEntities;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (disableExternalEntities) {
                this.disableExternalEntities(factory);
            }
            this.documentBuilder = factory.newDocumentBuilder();
            this.documentBuilder.setErrorHandler(this.errorHandler);
            this.schema = this.createSchema(xsdSchemaFilename);
        }
        catch (ParserConfigurationException exc) {
            throw new InitializationException(exc, "Failed loading XML document builder", new Object[0]);
        }
    }

    private void disableExternalEntities(DocumentBuilderFactory dbf) throws InitializationException {
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException exc) {
            throw new InitializationException(exc);
        }
    }

    private Schema createSchema(String xsdSchemaFilename) throws InitializationException {
        if (xsdSchemaFilename != null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream xsdStream = XMLToolkit.class.getResourceAsStream("/xsd/" + xsdSchemaFilename);
            StreamSource schemaFile = new StreamSource(xsdStream);
            try {
                return schemaFactory.newSchema(schemaFile);
            }
            catch (SAXException exc) {
                throw new InitializationException(exc, "Failed loading '%s'", xsdSchemaFilename);
            }
        }
        return null;
    }

    public Document newDocument() {
        return this.documentBuilder.newDocument();
    }

    public Element getDocumentRootFromFile(File xmlFile) throws FileNotFoundException, SerializeException {
        Element element;
        FileInputStream inputStream = null;
        UnicodeBOMInputStream unicodeBOMInputStream = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            unicodeBOMInputStream = new UnicodeBOMInputStream(inputStream);
            unicodeBOMInputStream.skipBOM();
            InputStreamReader reader = new InputStreamReader((InputStream)unicodeBOMInputStream, Charset.forName("UTF-8"));
            element = this.getDocumentRoot(new InputSource(reader));
        }
        catch (IOException exc) {
            try {
                throw new SerializeException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(unicodeBOMInputStream);
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close(unicodeBOMInputStream);
        StreamUtils.close(inputStream);
        return element;
    }

    public Element getDocumentRootFromInputStream(InputStream xmlInputStream) throws SerializeException {
        return this.getDocumentRoot(new InputSource(xmlInputStream));
    }

    public Element getDocumentRootFromString(String xmlData) throws SerializeException {
        return this.getDocumentRoot(new InputSource(new StringReader(xmlData)));
    }

    public Element getDocumentRoot(DOMSource domSource) throws SerializeException {
        this.validate(domSource);
        Document document = (Document)domSource.getNode();
        return document.getDocumentElement();
    }

    public Element getDocumentRoot(InputSource inputSource) throws SerializeException {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            if (this.disableExternalEntities) {
                this.disableExternalEntities(documentFactory);
            }
            documentFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentFactory.newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.parse(inputSource);
            this.validate(new DOMSource(document));
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException exc) {
            throw new SerializeException(exc);
        }
        catch (SAXException exc) {
            throw new SerializeException(exc);
        }
        catch (IOException exc) {
            throw new SerializeException(exc);
        }
        catch (InitializationException exc) {
            throw new SerializeException(exc);
        }
    }

    public void validate(Source source) throws SerializeException {
        try {
            if (this.schema != null) {
                Validator validator = this.schema.newValidator();
                validator.setErrorHandler(this.errorHandler);
                validator.validate(source);
            }
        }
        catch (SAXException exc) {
            throw new SerializeException(exc);
        }
        catch (IOException exc) {
            throw new SerializeException(exc);
        }
    }

    public void transform(Source xsltSource, Source xmlSource, Result result, Map<String, String> parameters) throws SerializeException {
        try {
            TransformerErrorListener errorListener = new TransformerErrorListener();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(errorListener);
            Transformer transformer = null;
            transformer = xsltSource == null ? transformerFactory.newTransformer() : transformerFactory.newTransformer(xsltSource);
            errorListener.throwException();
            if (parameters != null) {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            transformer.setErrorListener(errorListener);
            transformer.transform(xmlSource, result);
            errorListener.throwException();
        }
        catch (TransformerConfigurationException exc) {
            throw new SerializeException(exc);
        }
        catch (TransformerException exc) {
            throw new SerializeException(exc);
        }
        catch (NullPointerException exc) {
            throw new SerializeException("Failed to transform file", new Object[0]);
        }
    }

    public void transform(Source xsltSource, Source xmlSource, Result result) throws SerializeException {
        this.transform(xsltSource, xmlSource, result, null);
    }

    public void transform(Source xmlSource, Result result) throws SerializeException {
        this.transform(null, xmlSource, result);
    }

    public DateTime parseTime(String dateTimeString) {
        return DateTime.parse((String)dateTimeString);
    }

    public String formatTime(DateTime dateTime) {
        return dateTime.toLocalDateTime().toString();
    }

    public long getRelativeTime(DateTime now, DateTime time) {
        return Math.max(now.getMillis() - time.getMillis(), 0L);
    }

    public DateTime getLocalTimeFromRelativeTime(DateTime now, long timeOffset) {
        return now.minus(timeOffset);
    }

    private static class LoggingErrorHandler
    implements ErrorHandler {
        private LoggingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            logger.warn(exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            logger.error(exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            logger.error(exception.getMessage());
        }
    }
}

