/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.xml;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import at.mrdevelopment.toolkit.xml.helper.FileUploadInfo;
import at.mrdevelopment.toolkit.xml.helper.FormInfo;
import at.mrdevelopment.toolkit.xml.helper.FormsInfo;
import at.mrdevelopment.toolkit.xml.helper.HeaderInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTMLFormXMLSerializer
implements XMLSerializer<Void> {
    protected XMLToolkit xmlToolkit = new XMLToolkit();

    public static void main(String[] args) throws InitializationException, IOException, TransformerException {
        HeaderInfo headerInfo = new HeaderInfo("soihnfo");
        FileUploadInfo fileUploadInfos = new FileUploadInfo("caption", "name", "question");
        FormInfo formInfo = new FormInfo("action", "caption", "enctype", "method", "name", Lists.newArrayList((Object[])new FileUploadInfo[]{fileUploadInfos}));
        FormsInfo formsInfo = new FormsInfo(Lists.newArrayList((Object[])new FormInfo[]{formInfo}));
        HTMLFormXMLSerializer tox = new HTMLFormXMLSerializer();
        HTMLFormXMLSerializer.printDocument(tox.toXML(headerInfo, formsInfo), System.out);
    }

    public static void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public Document toXML(HeaderInfo headerInfo, FormsInfo formsInfo) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("root");
        Element formsElement = this.createFormsElement(document);
        for (FormInfo formInfo : formsInfo.getFormInfos()) {
            Element formElement = this.createFormElement(document, formInfo.getAction(), formInfo.getMethod(), formInfo.getName(), formInfo.getCaption(), formInfo.getEnctype());
            for (FileUploadInfo fileUploadInfo : formInfo.getFileUploadInfos()) {
                Element fileUploadElement = this.createFileUploadElement(document, fileUploadInfo.getName(), fileUploadInfo.getCaption(), fileUploadInfo.getQuestion());
                formElement.appendChild(fileUploadElement);
            }
            formsElement.appendChild(formElement);
        }
        root.appendChild(this.createHeaderElement(document, headerInfo.getCaption()));
        root.appendChild(formsElement);
        document.appendChild(root);
        return document;
    }

    protected Element createHeaderElement(Document document, String caption) {
        Element headerElement = document.createElement("header");
        headerElement.setTextContent(caption);
        return headerElement;
    }

    protected Element createFormsElement(Document document) {
        return document.createElement("forms");
    }

    protected Element createFormElement(Document document, String action, String method, String name, String caption, String enctype) {
        Element formElement = document.createElement("form");
        formElement.setAttribute("action", action);
        formElement.setAttribute("method", method);
        formElement.setAttribute("name", name);
        formElement.setAttribute("caption", caption);
        formElement.setAttribute("enctype", enctype);
        return formElement;
    }

    protected Element createFileUploadElement(Document document, String name, String caption, String question) {
        Element fileUploadElement = document.createElement("file-upload");
        fileUploadElement.setAttribute("name", name);
        fileUploadElement.setAttribute("caption", caption);
        fileUploadElement.setAttribute("question", question);
        return fileUploadElement;
    }
}

