/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.xml;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExceptionXMLSerializer
implements XMLSerializer<Throwable> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Throwable exception) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("error");
        element.setAttribute("class", exception.getClass().getName());
        element.setAttribute("message", exception.getMessage());
        for (StackTraceElement stackTrace : exception.getStackTrace()) {
            Element stackTraceElement = document.createElement("stack-trace");
            stackTraceElement.setAttribute("class", stackTrace.getClassName());
            stackTraceElement.setAttribute("method", stackTrace.getMethodName());
            stackTraceElement.setAttribute("file", stackTrace.getFileName());
            stackTraceElement.setAttribute("line", Integer.toString(stackTrace.getLineNumber()));
            element.appendChild(stackTraceElement);
        }
        document.appendChild(element);
        return document;
    }

    public Document messageToXML(int statusCode, String message) {
        Document document = this.xmlToolkit.newDocument();
        Element messageElement = document.createElement("message");
        messageElement.setAttribute("code", Integer.toString(statusCode));
        messageElement.setTextContent(message);
        document.appendChild(messageElement);
        return document;
    }

    public Throwable parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        String className = root.getAttribute("class");
        String message = root.getAttribute("message");
        NodeList stackTraceElements = root.getElementsByTagName("stack-trace");
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceElements.getLength()];
        for (int index = 0; index < stackTraceElements.getLength(); ++index) {
            Element element = (Element)stackTraceElements.item(index);
            String declaringClass = element.getAttribute("class");
            String methodName = element.getAttribute("method");
            String fileName = element.getAttribute("file");
            int lineNumber = Integer.parseInt(element.getAttribute("line"));
            stackTrace[index] = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }
        Throwable throwable = new Throwable(className + ": " + message);
        throwable.setStackTrace(stackTrace);
        return throwable;
    }
}

