/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.udp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.thinap.ThinAPListener;
import at.mrdevelopment.toolkit.udp.RemoteUDPHost;
import at.mrdevelopment.toolkit.udp.UDPRunnable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class SimplisticUDPHandler
extends UDPRunnable {
    private static ESLLogger logger = ESLLogger.getLogger(SimplisticUDPHandler.class);
    private static final long STARTING_TIMEOUT_IN_MS = 120000L;
    private static final long REGULAR_TIMEOUT_IN_MS = 3000L;
    private static final long SOCKET_TIMEOUT_IN_MS = 1000L;
    private final ThinAPListener receiver;
    private final byte[] INIT = "init".getBytes();
    private RemoteUDPHost lastController;
    private volatile RemoteUDPHost currentController;
    private long noPacketForMs;
    private boolean areWeStarting;

    public SimplisticUDPHandler(int apId, int localPort, ThinAPListener receiver) throws SocketException {
        super(new DatagramSocket(localPort));
        this.socket.setSoTimeout(1000);
        this.lastController = null;
        this.currentController = null;
        this.areWeStarting = false;
        this.noPacketForMs = 0L;
        this.receiver = receiver;
        Thread receiverThread = new Thread(this);
        receiverThread.setName("SimplisticUDPHandler - " + apId);
        receiverThread.start();
    }

    @Override
    protected void periodicTask() {
        try {
            this.innerPeriodicTask();
        }
        catch (Throwable thr) {
            logger.logException(thr);
        }
    }

    private void innerPeriodicTask() {
        RemoteUDPHost tempController = this.currentController;
        if (this.lastController != null) {
            if (!this.lastController.equals(tempController)) {
                this.lastController = tempController;
            }
        } else {
            this.lastController = tempController;
            if (this.lastController != null) {
                this.areWeStarting = true;
                this.noPacketForMs = 0L;
            }
        }
        long startTime = System.currentTimeMillis();
        byte[] buffer = new byte[523];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.socket.receive(packet);
            PacketSourceCheckStatus status = this.checkPacketSource(packet, tempController);
            if (status == PacketSourceCheckStatus.NO_CONTROLLER) {
                if (packet.getLength() == 4) {
                    boolean matches = true;
                    for (int idx = 0; idx < 4; ++idx) {
                        boolean bl = matches = packet.getData()[packet.getOffset() + idx] == this.INIT[idx];
                        if (!matches) break;
                    }
                    if (matches) {
                        logger.info("Received INIT from %s on port %d.", packet.getAddress().toString(), packet.getPort());
                        this.receiver.receivedInitFrom(new RemoteUDPHost(packet.getPort(), packet.getAddress()));
                    }
                }
            } else if (status == PacketSourceCheckStatus.CURRENT_CONTROLLER) {
                this.noPacketForMs = 0L;
                this.areWeStarting = false;
                if (packet.getLength() != 4) {
                    this.receiver.handleSlotSync(buffer);
                }
            } else {
                logger.warn("Got packet from different controller.");
                this.receiver.receivedPacketFromDifferentController();
            }
        }
        catch (SocketTimeoutException ste) {
            if (tempController != null) {
                this.noPacketForMs += System.currentTimeMillis() - startTime;
                if (this.areWeStarting) {
                    if (this.noPacketForMs >= 120000L) {
                        logger.info("Controller never responded.");
                        this.receiver.detectedLossOfConnectionFor(tempController, false);
                    }
                } else if (this.noPacketForMs >= 3000L) {
                    logger.info("Controller stopped responding.");
                    this.receiver.detectedLossOfConnectionFor(tempController, true);
                }
            }
        }
        catch (IOException ioe) {
            logger.error("Error receiving slot reply: %s.", ioe.getMessage());
            logger.logException(ioe);
        }
    }

    private PacketSourceCheckStatus checkPacketSource(DatagramPacket packet, RemoteUDPHost controller) {
        PacketSourceCheckStatus status = controller == null ? PacketSourceCheckStatus.NO_CONTROLLER : (controller.equals(packet.getPort(), packet.getAddress()) ? PacketSourceCheckStatus.CURRENT_CONTROLLER : PacketSourceCheckStatus.DIFFERENT_CONTROLLER);
        return status;
    }

    public void setController(RemoteUDPHost controller) {
        this.currentController = controller;
    }

    public void send(byte[] message, int destinationPort, InetAddress destinationAddress) {
        if (this.shutdownRequested) {
            return;
        }
        if (this.currentController == null) {
            return;
        }
        try {
            this.socket.send(new DatagramPacket(message, message.length, destinationAddress, destinationPort));
        }
        catch (IOException ioe) {
            logger.error("Error sending slot request: %s.", ioe.getMessage());
            logger.logException(ioe);
        }
    }

    private static enum PacketSourceCheckStatus {
        CURRENT_CONTROLLER,
        NO_CONTROLLER,
        DIFFERENT_CONTROLLER;

    }
}

