/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tree;

import at.mrdevelopment.toolkit.tree.Path;
import java.util.LinkedList;

public class ConstructiblePath
implements Path {
    private static final String DELIMITER = "/";
    private LinkedList<String> list = new LinkedList();

    public ConstructiblePath() {
    }

    public ConstructiblePath(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.list.add(args[i]);
        }
    }

    public ConstructiblePath(ConstructiblePath path) {
        for (String pathElem : path.list) {
            this.list.add(pathElem);
        }
    }

    public void addFirstElementToThis(String element) {
        this.list.addFirst(element);
    }

    public void addLastElementToThis(String element) {
        this.list.addLast(element);
    }

    @Override
    public Path addFirstElement(String element) {
        ConstructiblePath newPath = new ConstructiblePath(this);
        newPath.list.addFirst(element);
        return newPath;
    }

    @Override
    public Path addLastElement(String element) {
        ConstructiblePath newPath = new ConstructiblePath(this);
        newPath.list.addLast(element);
        return newPath;
    }

    @Override
    public Path removeFirstElement() {
        ConstructiblePath newPath = new ConstructiblePath(this);
        newPath.list.removeFirst();
        return newPath;
    }

    @Override
    public Path removeLastElement() {
        ConstructiblePath newPath = new ConstructiblePath(this);
        newPath.list.removeLast();
        return newPath;
    }

    @Override
    public String getElementAt(int i) {
        return this.list.get(i);
    }

    @Override
    public String getFirstElement() {
        return this.list.getFirst();
    }

    @Override
    public String getLastElement() {
        return this.list.getLast();
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DELIMITER);
        for (String elem : this.list) {
            builder.append(elem);
            builder.append(DELIMITER);
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructiblePath other = (ConstructiblePath)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    @Override
    public int compareTo(Path paramT) {
        String thisString = this.toString();
        String otherString = paramT.toString();
        return thisString.compareTo(otherString);
    }
}

