/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text.gui;

import at.mrdevelopment.toolkit.text.GlyphSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SymbolDialog {
    private static Font[] fontList = null;
    private Font font;
    private GlyphSet subset;
    private final JDialog dialog;
    private JTextField hexTextField;
    private Integer unicode;
    private JList list;
    private DefaultListModel model;
    private JComboBox subsetComboBox;
    private boolean ignoreChanges = false;

    public SymbolDialog(Frame frame) {
        this.dialog = new JDialog(frame, true);
        this.dialog.setTitle("Symbols");
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SymbolDialog.this.onCancelButton();
            }
        });
        JPanel topPanel = new JPanel(new FlowLayout(3));
        topPanel.add(new JLabel("Font:"));
        final JComboBox<Font> fontComboBox = new JComboBox<Font>(this.listFonts());
        final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        fontComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = value != null && !value.toString().isEmpty() ? ((Font)value).getName() : "";
                return renderer.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        });
        fontComboBox.setSelectedIndex(0);
        this.font = (Font)fontComboBox.getSelectedItem();
        fontComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SymbolDialog.this.font = (Font)fontComboBox.getSelectedItem();
                SymbolDialog.this.onFontChanged();
            }
        });
        topPanel.add(fontComboBox);
        topPanel.add(new JLabel("Subset:"));
        this.subsetComboBox = new JComboBox<GlyphSet>(GlyphSet.values());
        this.subsetComboBox.setEditable(false);
        this.subsetComboBox.setSelectedIndex(0);
        this.subset = (GlyphSet)((Object)this.subsetComboBox.getSelectedItem());
        this.subsetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!SymbolDialog.this.ignoreChanges) {
                    SymbolDialog.this.subset = (GlyphSet)((Object)SymbolDialog.this.subsetComboBox.getSelectedItem());
                    SymbolDialog.this.onSubsetChanged();
                }
            }
        });
        topPanel.add(this.subsetComboBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setVisibleRowCount(-1);
        final DefaultListCellRenderer charRenderer = new DefaultListCellRenderer();
        this.list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = charRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component instanceof JComponent) {
                    JComponent comp = (JComponent)component;
                    JPanel p = new JPanel(new FlowLayout(1, 0, 0));
                    p.setBackground(component.getBackground());
                    p.setForeground(component.getForeground());
                    p.setBorder(comp.getBorder());
                    comp.setFont(SymbolDialog.this.font.deriveFont(20.0f));
                    comp.setBorder(null);
                    p.add(component);
                    return p;
                }
                return component;
            }
        });
        this.list.setFont(this.list.getFont().deriveFont(20.0f));
        this.list.setLayoutOrientation(2);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!SymbolDialog.this.ignoreChanges && !e.getValueIsAdjusting()) {
                    SymbolDialog.this.listSelectionChanged();
                }
            }
        });
        centerPanel.add((Component)new JScrollPane(this.list), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel lowerPanel = new JPanel(new FlowLayout(2));
        lowerPanel.add(new JLabel("Unicode char:"));
        this.hexTextField = new JTextField(5);
        this.hexTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SymbolDialog.this.validateHexValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SymbolDialog.this.validateHexValue();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SymbolDialog.this.validateHexValue();
            }
        });
        lowerPanel.add(this.hexTextField);
        bottomPanel.add((Component)lowerPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton insertButton = new JButton("Insert");
        insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SymbolDialog.this.onInsertButton();
            }
        });
        buttonPanel.add(insertButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SymbolDialog.this.onCancelButton();
            }
        });
        buttonPanel.add(cancelButton);
        bottomPanel.add((Component)buttonPanel, "South");
        this.updateContent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SymbolDialog.this.list.setSelectedIndex(0);
            }
        });
        this.dialog.add((Component)bottomPanel, "South");
        this.dialog.add((Component)centerPanel, "Center");
        this.dialog.add((Component)topPanel, "North");
        this.dialog.setPreferredSize(new Dimension(400, 300));
        this.registerEscapeKeyAction(this.dialog);
        this.dialog.pack();
    }

    private void updateContent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SymbolDialog.this.model.removeAllElements();
                List<String> glyphList = SymbolDialog.this.subset.getGlyphList(SymbolDialog.this.font);
                for (String glyph : glyphList) {
                    SymbolDialog.this.model.addElement(glyph);
                }
            }
        });
    }

    protected void listSelectionChanged() {
        Object obj = this.list.getSelectedValue();
        if (obj != null && !obj.toString().isEmpty()) {
            String character = obj.toString();
            char c = character.toCharArray()[0];
            String unicodeString = Integer.toHexString(c | 0x10000).substring(1);
            this.ignoreChanges = true;
            this.hexTextField.setText(unicodeString.toUpperCase());
            this.ignoreChanges = false;
            this.unicode = Integer.valueOf(unicodeString, 16);
        }
    }

    protected void onCancelButton() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.font = null;
        this.subset = null;
        this.unicode = null;
    }

    protected void onInsertButton() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    protected void validateHexValue() {
        String text;
        if (!this.ignoreChanges && (text = this.hexTextField.getText()) != null && !text.isEmpty()) {
            try {
                this.unicode = Integer.parseInt(text, 16);
                this.updateCaretPosition();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void updateCaretPosition() {
        GlyphSet foundSet = null;
        for (GlyphSet glyphSet : GlyphSet.values()) {
            if (this.unicode < glyphSet.getStart() || this.unicode > glyphSet.getEnd()) continue;
            foundSet = glyphSet;
            break;
        }
        if (foundSet != null) {
            final GlyphSet glyph = foundSet;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SymbolDialog.this.ignoreChanges = true;
                    SymbolDialog.this.subset = glyph;
                    SymbolDialog.this.subsetComboBox.setSelectedItem((Object)glyph);
                    SymbolDialog.this.model.removeAllElements();
                    List<String> glyphList = SymbolDialog.this.subset.getGlyphList(SymbolDialog.this.font);
                    for (String glyph2 : glyphList) {
                        SymbolDialog.this.model.addElement(glyph2);
                    }
                    SymbolDialog.this.list.setSelectedIndex(SymbolDialog.this.unicode - glyph.getStart());
                    SymbolDialog.this.ignoreChanges = false;
                }
            });
        }
    }

    protected void onSubsetChanged() {
        this.updateContent();
        this.hexTextField.setText(String.format("%04X", this.subset.getStart()));
    }

    protected void onFontChanged() {
        final int selectedIndex = this.list.getSelectedIndex();
        this.updateContent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SymbolDialog.this.list.setSelectedIndex(selectedIndex);
            }
        });
    }

    private Font[] listFonts() {
        if (fontList == null) {
            fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        }
        return fontList;
    }

    public void showDialog(JFrame parentFrame) {
        this.dialog.setLocationRelativeTo(parentFrame);
        this.dialog.setVisible(true);
    }

    private void registerEscapeKeyAction(JDialog dialog) {
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SymbolDialog.this.onCancelButton();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public Font getFont() {
        return this.font;
    }

    public GlyphSet getSubset() {
        return this.subset;
    }

    public Integer getUnicode() {
        return this.unicode;
    }

    public boolean hasResult() {
        return this.getFont() != null && this.getSubset() != null && this.getUnicode() != null;
    }
}

