/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text.bullet;

import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.Word;
import at.mrdevelopment.toolkit.text.bullet.Bullet;
import at.mrdevelopment.toolkit.text.bullet.BulletSpacing;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ImageBullet
extends Bullet {
    private final BufferedImage bulletImage;
    private String bulletImageFile;
    private int offset;

    public ImageBullet(Map<String, Option<?>> options, File workingDirectory, String bulletImage, Word.RenderingHint renderingHint, BulletSpacing bulletSpacing) throws OptionException {
        super(options, renderingHint, bulletSpacing);
        this.bulletImageFile = bulletImage;
        try {
            this.bulletImage = ImageUtils.loadImageSource(workingDirectory, bulletImage);
        }
        catch (IOException exc) {
            throw new OptionException("Could not load bullet image", exc);
        }
    }

    @Override
    public int getWidth(Graphics2D graphics) throws OptionException {
        return this.bulletImage.getWidth() + this.getBulletSpacing().getWidth(graphics);
    }

    @Override
    public Rectangle getBounds(Graphics2D graphics, int xPos, int yPos) throws OptionException {
        return super.getBounds(graphics, xPos, this.calculateYPos(yPos));
    }

    @Override
    public Rectangle getTextBounds(Graphics2D graphics, int xPos, int yPos) throws OptionException {
        return this.getBounds(graphics, xPos, yPos);
    }

    private int calculateYPos(int yPos) {
        return yPos + (this.offset < 0 ? Math.abs(this.offset) : 0);
    }

    @Override
    public Rectangle draw(Graphics2D graphics, int widht, int height, int xPos, int yPos) throws OptionException {
        graphics.drawImage((Image)this.bulletImage, xPos + this.getBulletSpacing().getSpacingBefore(graphics), this.calculateYPos(yPos), null);
        return this.getBounds(graphics, xPos, yPos);
    }

    @Override
    public String toString() {
        return "[" + this.bulletImageFile + "]";
    }

    @Override
    public int getHeight(Graphics2D graphics) throws OptionException {
        return this.bulletImage.getHeight() + super.getLineSpacing();
    }

    @Override
    public int getAscent(Graphics2D graphics) throws OptionException {
        this.offset = this.calculateMaxWordHeight();
        return this.offset > 0 ? this.offset : 0;
    }

    private int calculateMaxWordHeight() throws OptionException {
        if (this.getParent() != null && this.getParent() instanceof TextElement) {
            List<Word> leaves = this.getParent().getLeaves();
            Graphics2D graphics = this.bulletImage.createGraphics();
            int maxHeight = 0;
            int maxAscent = 0;
            for (Word word : leaves) {
                if (word instanceof ImageBullet) continue;
                maxHeight = Math.max(word.getHeight(graphics), maxHeight);
                maxAscent = Math.max(word.getAscent(graphics), maxAscent);
            }
            int heightDifference = this.getHeight(graphics) / 2 - maxHeight / 2;
            graphics.dispose();
            return heightDifference > 0 ? maxAscent + heightDifference : heightDifference;
        }
        return 0;
    }

    @Override
    protected int getDescent(Graphics2D graphics) throws OptionException {
        return 0;
    }

    @Override
    protected int getLeading(Graphics2D graphics) throws OptionException {
        return 0;
    }

    @Override
    public void applyWrappedLineSpace() throws OptionException {
    }

    @Override
    public boolean isCondenseEnabled() throws OptionException {
        return false;
    }

    @Override
    public boolean hasCondenseStepsRemaining() throws OptionException {
        return false;
    }

    @Override
    public boolean nextMinimumFontSize() throws OptionException {
        return false;
    }

    @Override
    public boolean nextFontSize() throws OptionException {
        return false;
    }

    @Override
    public double nextCondenseFactor() throws OptionException {
        return 1.0;
    }

    @Override
    public void setCondenseFactor(int condenseFactorIndex) throws OptionException {
    }

    @Override
    public void setFixedCondenseFactor(int condenseFactorIndex) throws OptionException {
    }

    @Override
    public boolean hasFontSizesRemaining() throws OptionException {
        return false;
    }

    @Override
    public boolean isMinimumFontSizeSet() {
        return true;
    }
}

