/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.TextTestUtils;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WordTest {
    private static final int IMAGE_WIDTH = 200;
    private static final int IMAGE_HEIGHT = 200;
    private static final int IMAGE_TYPE = 2;
    final String str1 = "text";
    final String str2 = " ";
    final String str3 = "";
    final String str4;
    Word w1;
    Word w2;
    Word w3;
    Word w4;
    Word wn1;
    Word wn2;
    Word wn3;
    Word wn4;
    Map<String, Option<?>> w1opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Verdana", Attribute.FONT_SIZE, "10", Attribute.COLOR, "RED"});
    Map<String, Option<?>> w2opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Arial", Attribute.FONT_SIZE, "20", Attribute.FONT_WEIGHT, "bold", Attribute.BACKGROUND_COLOR, "GREEN"});
    Map<String, Option<?>> w3opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Verdana", Attribute.FONT_SIZE, "10", Attribute.BACKGROUND_COLOR, "BLUE"});
    Map<String, Option<?>> w4opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Arial", Attribute.FONT_SIZE, "20", Attribute.FONT_WEIGHT, "bold", Attribute.COLOR, "GRAY"});
    Word cw1;
    Word cw2;
    Word cw3;
    Word cw4;
    private BufferedImage canvas;
    private Graphics2D graphics;

    public WordTest() {
        this.str4 = null;
    }

    @Before
    public void setUp() throws Exception {
        this.canvas = new BufferedImage(200, 200, 2);
        this.graphics = this.canvas.createGraphics();
        this.w1 = new Word("text", this.w1opt);
        this.w2 = new Word(" ", this.w2opt);
        this.w3 = new Word("", this.w3opt);
        this.w4 = new Word(this.str4, this.w4opt);
        this.wn1 = new Word("text", this.w1opt);
        this.wn2 = new Word(" ", this.w1opt);
        this.wn3 = new Word("", this.w1opt);
        this.wn4 = new Word(this.str4, this.w1opt);
        this.cw1 = new Word(this.w1);
        this.cw2 = new Word(this.w2);
        this.cw3 = new Word(this.w3);
        this.cw4 = new Word(this.w4);
    }

    @After
    public void tearDown() throws Exception {
        this.graphics.dispose();
    }

    @Test
    public void testGetLeaves() throws OptionException {
        Word word = new Word("text", new HashMap());
        List<Word> leaves = word.getLeaves();
        Assert.assertNotNull(leaves);
        Assert.assertEquals((long)1L, (long)leaves.size());
        word = new Word("two words", new HashMap());
        leaves = word.getLeaves();
        Assert.assertNotNull(leaves);
        Assert.assertEquals((long)1L, (long)leaves.size());
    }

    @Test
    public void testWordString() throws OptionException {
        Assert.assertEquals((Object)"text", (Object)this.w1.getText());
        Assert.assertEquals((Object)" ", (Object)this.w2.getText());
        Assert.assertEquals((Object)"", (Object)this.w3.getText());
        Assert.assertEquals((Object)"", (Object)this.w4.getText());
    }

    @Test
    public void testWordWord() throws OptionException {
        Assert.assertEquals((Object)"text", (Object)this.cw1.getText());
        Assert.assertEquals((Object)" ", (Object)this.cw2.getText());
        Assert.assertEquals((Object)"", (Object)this.cw3.getText());
        Assert.assertEquals((Object)"", (Object)this.cw4.getText());
        Assert.assertTrue((boolean)this.w1.optionContainer.matchingOptions(this.cw1.optionContainer));
        Assert.assertTrue((boolean)this.w2.optionContainer.matchingOptions(this.cw2.optionContainer));
        Assert.assertTrue((boolean)this.w3.optionContainer.matchingOptions(this.cw3.optionContainer));
        Assert.assertTrue((boolean)this.w4.optionContainer.matchingOptions(this.cw4.optionContainer));
    }

    @Test
    public void testGetWidth() throws OptionException {
        int ww1 = this.wn1.getWidth(this.graphics);
        int ww2 = this.wn2.getWidth(this.graphics);
        int ww3 = this.wn3.getWidth(this.graphics);
        int ww4 = this.wn4.getWidth(this.graphics);
        Assert.assertEquals((long)22L, (long)ww1);
        Assert.assertEquals((long)4L, (long)ww2);
        Assert.assertEquals((long)0L, (long)ww3);
        Assert.assertEquals((long)0L, (long)ww4);
    }

    @Test
    public void testGetBounds() throws OptionException {
        Rectangle rw1 = this.wn1.getBounds(this.graphics, 0, 0);
        Rectangle rw2 = this.wn2.getBounds(this.graphics, 0, 0);
        Rectangle rw3 = this.wn3.getBounds(this.graphics, 0, 0);
        Rectangle rw4 = this.wn4.getBounds(this.graphics, 0, 0);
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw1.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw2.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw3.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw4.getHeight()));
        Assert.assertEquals((Object)new Double(22.0), (Object)new Double(rw1.getWidth()));
        Assert.assertEquals((Object)new Double(4.0), (Object)new Double(rw2.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw3.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw4.getWidth()));
    }

    @Test
    public void testGetBoundsMixedFonts() throws OptionException {
        Rectangle rw1 = this.w1.getBounds(this.graphics, 0, 0);
        Rectangle rw2 = this.w2.getBounds(this.graphics, 0, 0);
        Rectangle rw3 = this.w3.getBounds(this.graphics, 0, 0);
        Rectangle rw4 = this.w4.getBounds(this.graphics, 0, 0);
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw1.getHeight()));
        Assert.assertEquals((Object)new Double(19.0), (Object)new Double(rw2.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw3.getHeight()));
        Assert.assertEquals((Object)new Double(19.0), (Object)new Double(rw4.getHeight()));
        Assert.assertEquals((Object)new Double(22.0), (Object)new Double(rw1.getWidth()));
        Assert.assertEquals((Object)new Double(6.0), (Object)new Double(rw2.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw3.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw4.getWidth()));
    }

    @Test
    public void testDraw() throws OptionException {
        Rectangle rw1 = this.wn1.draw(this.graphics, 200, 200, 0, 0);
        Rectangle rw2 = this.wn2.draw(this.graphics, 200, 200, 0, 0);
        Rectangle rw3 = this.wn3.draw(this.graphics, 200, 200, 0, 0);
        Rectangle rw4 = this.wn4.draw(this.graphics, 200, 200, 0, 0);
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw1.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw2.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw3.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw4.getHeight()));
        Assert.assertEquals((Object)new Double(22.0), (Object)new Double(rw1.getWidth()));
        Assert.assertEquals((Object)new Double(4.0), (Object)new Double(rw2.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw3.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw4.getWidth()));
    }

    @Test
    public void testDrawMixedFonts() throws OptionException {
        Rectangle rw1 = this.w1.draw(this.graphics, 200, 200, 0, 0);
        Rectangle rw2 = this.w2.draw(this.graphics, 200, 200, 0, 0);
        Rectangle rw3 = this.w3.draw(this.graphics, 200, 200, 0, 0);
        Rectangle rw4 = this.w4.draw(this.graphics, 200, 200, 0, 0);
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw1.getHeight()));
        Assert.assertEquals((Object)new Double(19.0), (Object)new Double(rw2.getHeight()));
        Assert.assertEquals((Object)new Double(11.0), (Object)new Double(rw3.getHeight()));
        Assert.assertEquals((Object)new Double(19.0), (Object)new Double(rw4.getHeight()));
        Assert.assertEquals((Object)new Double(22.0), (Object)new Double(rw1.getWidth()));
        Assert.assertEquals((Object)new Double(6.0), (Object)new Double(rw2.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw3.getWidth()));
        Assert.assertEquals((Object)new Double(0.0), (Object)new Double(rw4.getWidth()));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"[text]", (Object)this.w1.toString());
        Assert.assertEquals((Object)"[ ]", (Object)this.w2.toString());
        Assert.assertEquals((Object)"[]", (Object)this.w3.toString());
        Assert.assertEquals((Object)"[]", (Object)this.w4.toString());
    }
}

