/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.ShadowProperties;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Const;
import at.mrdevelopment.toolkit.text.Drawable;
import at.mrdevelopment.toolkit.text.ListElement;
import at.mrdevelopment.toolkit.text.ListItem;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.TextUtils;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Word
extends TextElement
implements Drawable {
    private String text;
    private boolean bullet = false;
    private boolean skipped;
    private RenderingHint renderingHint = RenderingHint.NONE;
    private final ShadowProperties shadowProperties;

    public Word(String text, Map<String, Option<?>> options, RenderingHint renderingHint) throws OptionException, IllegalArgumentException {
        this(text, options, renderingHint, false);
    }

    public Word(String text, Map<String, Option<?>> options) throws OptionException, IllegalArgumentException {
        this(text, options, RenderingHint.NONE);
    }

    public Word(Word word) throws OptionException {
        super(word.getOptions(), true);
        this.setParent(word.getParent());
        this.optionContainer.inherit(word.optionContainer);
        this.text = word.text;
        this.renderingHint = RenderingHint.NONE;
        this.shadowProperties = this.initShadowProperties();
    }

    public Word(Word word, boolean bullet, RenderingHint renderingHint) throws OptionException {
        this(word);
        this.renderingHint = renderingHint;
        this.bullet = bullet;
    }

    public Word(Map<String, Option<?>> options, Word ... words) throws OptionException {
        this(options, RenderingHint.NONE, words);
    }

    public Word(Map<String, Option<?>> options, RenderingHint renderingHint, Word ... words) throws OptionException {
        super(options, true);
        this.renderingHint = renderingHint;
        this.shadowProperties = this.initShadowProperties();
        StringBuilder builder = new StringBuilder();
        for (Word word : words) {
            if (word == null || word.text == null || word.text.isEmpty()) continue;
            builder.append(word.text);
        }
        this.text = builder.toString();
    }

    public Word(String text, Map<String, Option<?>> options, RenderingHint renderingHint, boolean bullet) throws IllegalArgumentException, OptionException {
        super(options, true);
        this.renderingHint = renderingHint;
        this.bullet = bullet;
        this.shadowProperties = this.initShadowProperties();
        if (text == null || !bullet && text.isEmpty()) {
            throw new IllegalArgumentException("Cannot create empty word");
        }
        this.text = text;
    }

    public Word(Map<String, Option<?>> options, boolean bullet, RenderingHint renderingHint, Word ... words) throws OptionException {
        this(options, renderingHint, words);
        this.bullet = bullet;
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    private static Map<String, Option<?>> createDefaultOptions() throws OptionException {
        HashMap options = new HashMap();
        for (Attribute attribute : TemplateNode.SPAN.getAttributeList()) {
            try {
                options.put(attribute.getKey(), attribute.createOption());
            }
            catch (Exception exc) {
                throw new OptionException(exc);
            }
        }
        return options;
    }

    public static Word newlineWord() throws OptionException {
        return Word.newlineWord(Word.createDefaultOptions());
    }

    public static Word newlineWord(Map<String, Option<?>> options) throws OptionException {
        return new Word(Const.NEWLINE, options);
    }

    public static Word newLineWord(Map<String, Option<?>> options, boolean bullet, RenderingHint renderingHint) throws OptionException {
        return new Word(Const.NEWLINE, options, renderingHint, bullet);
    }

    public static Word newLineWord(Map<String, Option<?>> options, RenderingHint renderingHint) throws OptionException {
        return new Word(Const.NEWLINE, options, renderingHint);
    }

    public static Word delimiterWord(Map<String, Option<?>> options) throws OptionException {
        return new Word(" ", options);
    }

    public static Word delimiterWord(Map<String, Option<?>> options, boolean bullet, RenderingHint renderingHint) throws IllegalArgumentException, OptionException {
        return new Word(" ", options, renderingHint, bullet);
    }

    public static Word nonBreakingDelimiterWord(Map<String, Option<?>> options) throws OptionException {
        return new Word(Const.NON_BREAKING_DELIMITER, options);
    }

    public boolean isNewline() {
        return Const.NEWLINE.equals(this.getText());
    }

    public boolean isDelimiter() {
        return " ".equals(this.getText());
    }

    public boolean isEmpty() {
        return this.getText().isEmpty();
    }

    public boolean isIgnoreIfDrawnIncomplete() {
        return this.renderingHint.equals((Object)RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT);
    }

    public boolean isFloat() {
        return this.renderingHint.equals((Object)RenderingHint.FLOAT);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public int getXOffsetForMultipleLines(Graphics2D graphics) throws OptionException {
        if (this.getParent() instanceof ListElement || this.getParent() instanceof ListItem) {
            ListElement listElement;
            ListElement listElement2 = listElement = this.getParent() instanceof ListElement ? (ListElement)this.getParent() : (ListElement)this.getParent().getParent();
            if (this.getParent() instanceof ListItem) {
                ListItem listItem = (ListItem)this.getParent();
                return listElement.getXOffsetForMultipleLines(graphics, listItem);
            }
        }
        return 0;
    }

    @Override
    protected void graphicsObjectChanged(Graphics2D graphics) throws OptionException {
        if (!this.fontSizeContainer.containsWidth(this.currentFontSizeIndex, this.currentCondenseFactorIndex)) {
            String currentText = this.getUnicodeUpdatedText();
            if (!currentText.isEmpty()) {
                double wordWidth = 0.0;
                try {
                    AttributedString attributedString = new AttributedString(currentText, this.getFont().getAttributes());
                    int paragraphEnd = attributedString.getIterator().getEndIndex();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(attributedString.getIterator(), graphics.getFontRenderContext());
                    float breakWidth = Float.MAX_VALUE;
                    TextLayout layout = measurer.nextLayout(breakWidth);
                    Shape blackBoxBounds = layout.getBlackBoxBounds(0, paragraphEnd);
                    wordWidth = blackBoxBounds.getBounds().x + blackBoxBounds.getBounds().width;
                    if (TextUtils.isWhitespace(currentText.substring(currentText.length() - 1)) || wordWidth == 0.0) {
                        wordWidth = Math.round(layout.getAdvance());
                    }
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    wordWidth = graphics.getFontMetrics(this.getFont()).getStringBounds(currentText, graphics).getWidth();
                }
                this.fontSizeContainer.storeWidth(this.currentFontSizeIndex, this.currentCondenseFactorIndex, this.getAdditionalSize() + (int)Math.round((double)Math.round(wordWidth * 10.0) / 10.0));
            } else {
                this.fontSizeContainer.storeWidth(this.currentFontSizeIndex, this.currentCondenseFactorIndex, 0);
            }
        }
    }

    private int getAdditionalSize() throws OptionException {
        int additionalSize = 0;
        if (!this.isOutlineInside() && this.getOutlineThickness() > 1) {
            additionalSize += this.getOutlineThickness() * 2;
        }
        if (this.isShadowEnabled()) {
            additionalSize += this.isShadowBlur() ? this.getShadowSize() * 3 : this.getShadowSize() * 2;
        }
        return additionalSize;
    }

    @Override
    public int getHeight(Graphics2D graphics) throws OptionException {
        return super.getHeight(graphics) + this.getAdditionalSize();
    }

    public int getWidth(Graphics2D graphics) throws OptionException {
        if (!this.fontSizeContainer.containsWidth(this.currentFontSizeIndex, this.currentCondenseFactorIndex)) {
            this.graphicsObjectChanged(graphics);
        }
        return this.fontSizeContainer.getWidth(this.currentFontSizeIndex, this.currentCondenseFactorIndex);
    }

    @Override
    public Rectangle getBounds(Graphics2D graphics, int xPos, int yPos) throws OptionException {
        Rectangle bounds = new Rectangle(new Point(xPos, yPos));
        int botRightX = xPos + this.getWidth(graphics);
        int botRightY = yPos + this.getHeight(graphics);
        bounds.add(new Point(botRightX, botRightY));
        bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        return bounds;
    }

    @Override
    public Rectangle getTextBounds(Graphics2D graphics, int xPos, int yPos) throws OptionException {
        TextLayout textLayout = new TextLayout(this.getUnicodeUpdatedText(), this.getFont(), graphics.getFontRenderContext());
        Rectangle bounds = new Rectangle(new Point(xPos, yPos));
        int botRightX = xPos + (int)Math.round(textLayout.getBounds().getWidth());
        int botRightY = yPos - Math.round(new TextLayout(this.getUnicodeUpdatedText(), this.getFont(), graphics.getFontRenderContext()).getAscent());
        bounds.add(new Point(botRightX, botRightY));
        bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        return this.getBounds(graphics, xPos, yPos);
    }

    @Override
    public Rectangle draw(Graphics2D graphics, int width, int height, int xPos, int yPos) throws OptionException {
        BufferedImage img = null;
        Graphics2D inputGraphics = graphics;
        Rectangle bounds = this.getBounds(graphics, xPos, yPos);
        if (this.isShadowEnabled()) {
            img = graphics.getDeviceConfiguration().createCompatibleImage(width, height);
            graphics = img.createGraphics();
        }
        graphics.setFont(this.getFont());
        int topLeftXForDrawing = xPos;
        int topLeftYForDrawing = yPos + this.getAscent(graphics);
        if (this.isOutline()) {
            AffineTransform tx = new AffineTransform();
            TextLayout textLayout = new TextLayout(this.getUnicodeUpdatedText(), this.getFont(), graphics.getFontRenderContext());
            Shape outline = textLayout.getOutline(null);
            Rectangle2D outlineBounds = outline.getBounds2D();
            double topOffset = 0.0;
            if (outlineBounds.getY() + outlineBounds.getHeight() > 0.0) {
                double tmp = Math.abs(outlineBounds.getY() + outlineBounds.getHeight());
                topOffset = (double)textLayout.getAscent() - outlineBounds.getHeight() + tmp;
            } else if ((double)textLayout.getAscent() > outlineBounds.getHeight()) {
                topOffset = (double)textLayout.getAscent() - outlineBounds.getHeight();
            }
            double usedXPos = this.isOutlineInside() || this.getOutlineThickness() == 1 ? 0.0 : (double)(this.getOutlineThickness() / 2);
            tx.translate((double)xPos + usedXPos - (double)outline.getBounds().x, (double)(yPos - outline.getBounds().y) + (topOffset += this.isOutlineInside() || this.getOutlineThickness() == 1 ? 0.0 : (double)(this.getOutlineThickness() / 2)));
            outline = textLayout.getOutline(tx);
            if (this.isOutlineInside() || this.getOutlineThickness() == 1) {
                graphics.setPaint(this.optionContainer.getColorOptionValue(Attribute.COLOR.getKey()));
                graphics.fill(outline);
                graphics.setPaint(this.getOutlineColor());
                graphics.setStroke(new BasicStroke(this.getOutlineThickness()));
                graphics.draw(outline);
            } else {
                graphics.setPaint(this.getOutlineColor());
                graphics.setStroke(new BasicStroke(this.getOutlineThickness(), 1, 1));
                graphics.draw(outline);
                graphics.setPaint(this.optionContainer.getColorOptionValue(Attribute.COLOR.getKey()));
                graphics.fill(outline);
            }
        } else {
            graphics.setPaint(this.optionContainer.getColorOptionValue(Attribute.COLOR.getKey()));
            graphics.drawString(this.getUnicodeUpdatedText(), topLeftXForDrawing, topLeftYForDrawing);
        }
        if (this.isShadowEnabled()) {
            BufferedImage applyShadow = ImageUtils.applyShadow(img, this.shadowProperties);
            inputGraphics.drawImage(applyShadow, null, 0, 0);
        }
        return bounds;
    }

    public String toString() {
        return "[" + this.text + "]";
    }

    @Override
    public List<Word> getLeaves() {
        ArrayList<Word> leaves = new ArrayList<Word>();
        leaves.add(this);
        return leaves;
    }

    public boolean isBullet() {
        return this.bullet;
    }

    @Override
    protected void propagateOptions() throws OptionException {
    }

    @Override
    public Map<String, Option<?>> getOptions() {
        return super.getOptions();
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public RenderingHint getRenderingHint() {
        return this.renderingHint;
    }

    public int getDelimiterWidth(Graphics2D graphics) throws OptionException {
        TextLayout layout = new TextLayout(" ", this.getFont(), graphics.getFontRenderContext());
        return Math.round(layout.getAdvance());
    }

    public boolean isOutline() throws OptionException {
        return this.optionContainer.getBooleanOptionValue(Attribute.OUTLINE.getKey());
    }

    public int getOutlineThickness() throws OptionException {
        return this.optionContainer.getIntegerOptionValue(Attribute.OUTLINE_THICKNESS.getKey());
    }

    public Paint getOutlineColor() throws OptionException {
        return this.optionContainer.getColorOptionValue(Attribute.OUTLINE_COLOR.getKey());
    }

    public boolean isOutlineInside() throws OptionException {
        return this.optionContainer.getBooleanOptionValue(Attribute.OUTLINE_INSIDE.getKey());
    }

    public boolean isShadowEnabled() throws OptionException {
        return this.optionContainer.getBooleanOptionValue(Attribute.SHADOW.getKey());
    }

    public Paint getShadowColor() throws OptionException {
        return this.shadowProperties.getColor();
    }

    public int getShadowSize() throws OptionException {
        return this.shadowProperties.getSize();
    }

    public double getShadowAlpha() {
        return this.shadowProperties.getAlpha();
    }

    public boolean isShadowBlur() {
        return this.shadowProperties.isBlur();
    }

    private ShadowProperties initShadowProperties() throws OptionException {
        return new ShadowProperties(this.optionContainer.getColorOptionValue(Attribute.SHADOW_COLOR.getKey()), this.optionContainer.getIntegerOptionValue(Attribute.SHADOW_SIZE.getKey()), this.optionContainer.getDoubleOptionValue(Attribute.SHADOW_ALPHA.getKey()), this.optionContainer.getBooleanOptionValue(Attribute.SHADOW_BLUR.getKey()), this.optionContainer.getDoubleOptionValue(Attribute.SHADOW_ANGLE.getKey()));
    }

    public static enum RenderingHint {
        NONE,
        IGNORE_IF_NOT_DRAWN_CORRECT,
        FLOAT;

    }
}

