/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.TextTestUtils;
import at.mrdevelopment.toolkit.text.TextUtils;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextUtilsTest {
    private static final int IMAGE_WIDTH = 200;
    private static final int IMAGE_HEIGHT = 200;
    private static final int IMAGE_TYPE = 2;
    private BufferedImage canvas;
    private Graphics2D graphics;
    private static final String STR1 = "text";
    private static final String STR2 = " ";
    private static final String STR3 = "";
    private static final String STR4 = null;
    private Word w1;
    private Word w2;
    private Word w3;
    private Word w4;
    Map<String, Option<?>> w1opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Verdana", Attribute.FONT_SIZE, "10", Attribute.COLOR, "RED"});
    Map<String, Option<?>> w2opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Arial", Attribute.FONT_SIZE, "20", Attribute.FONT_WEIGHT, "bold", Attribute.BACKGROUND_COLOR, "GREEN"});
    Map<String, Option<?>> w3opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Verdana", Attribute.FONT_SIZE, "10", Attribute.BACKGROUND_COLOR, "BLUE"});
    Map<String, Option<?>> w4opt = TextTestUtils.createOptions(new Object[]{Attribute.FONT_FAMILY, "Arial", Attribute.FONT_SIZE, "20", Attribute.FONT_WEIGHT, "bold", Attribute.COLOR, "GRAY"});

    @Before
    public void setUp() throws Exception {
        this.canvas = new BufferedImage(200, 200, 2);
        this.graphics = this.canvas.createGraphics();
        this.w1 = new Word(STR1, this.w1opt);
        this.w2 = new Word(STR2, this.w2opt);
        this.w3 = new Word(STR3, this.w3opt);
        this.w4 = new Word(STR4, this.w4opt);
    }

    @After
    public void tearDown() throws Exception {
        this.graphics.dispose();
    }

    @Test
    public void testGetContentWidthHomogenous1() throws OptionException {
        List<Word> words = this.fillHomogenous("test", STR2, "1 ", "2 ", "3");
        Assert.assertEquals((long)50L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    @Test
    public void testGetContentWidthHomogenous2() throws OptionException {
        List<Word> words = this.fillHomogenous("test", STR2, "1 ", "2", STR2, "3");
        Assert.assertEquals((long)50L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    @Test
    public void testGetContentWidthHomogenous3() throws OptionException {
        List<Word> words = this.fillHomogenous(" test", STR2, "1", "2 ", "3");
        Assert.assertEquals((long)50L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    @Test
    public void testGetContentWidthHomogenous4() throws OptionException {
        List<Word> words = this.fillHomogenous("test  ", STR2, "1", "2", "3");
        Assert.assertEquals((long)50L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    @Test
    public void testGetContentWidthHomogenous5() throws OptionException {
        List<Word> words = this.fillHomogenous("test", STR2, "1", "2", "3  ");
        Assert.assertEquals((long)50L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    @Test
    public void testGetContentWidthHomogenous6() throws OptionException {
        List<Word> words = this.fillHomogenous("test", STR2, "1", " 2", " 3");
        Assert.assertEquals((long)50L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    @Test
    public void testGetContentWidthMixed1() throws OptionException {
        List<Word> words = this.fillMixed();
        Assert.assertEquals((long)28L, (long)TextUtils.getContentWidth(words, this.graphics));
    }

    private List<Word> fillHomogenous(String ... wordStrings) throws OptionException {
        ArrayList<Word> words = new ArrayList<Word>();
        for (String wordString : wordStrings) {
            Word word = new Word(wordString, TextTestUtils.createOptions(Attribute.FONT_FAMILY.getKey(), "Arial", Attribute.FONT_SIZE.getKey(), "12"));
            words.add(word);
        }
        return words;
    }

    private List<Word> fillMixed() throws OptionException {
        ArrayList<Word> words = new ArrayList<Word>();
        words.add(this.w1);
        words.add(this.w2);
        words.add(this.w3);
        words.add(this.w4);
        return words;
    }
}

