/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TextUtils {
    private static final int CUSTOM_UNICODE_OFFSET = 61440;

    public static int getContentWidth(List<Word> words, Graphics2D graphics, int firstWordIndex, int lastWordIndex) throws IndexOutOfBoundsException, OptionException {
        if (firstWordIndex > lastWordIndex) {
            throw new IndexOutOfBoundsException("Start index can't be greater than end index");
        }
        if (lastWordIndex >= words.size()) {
            throw new IndexOutOfBoundsException("End index can't be greater than size of list");
        }
        if (words.isEmpty()) {
            return 0;
        }
        int width = 0;
        for (int i = firstWordIndex; i <= lastWordIndex; ++i) {
            Word word = words.get(i);
            width += word.getWidth(graphics);
        }
        return width;
    }

    public static boolean isFontAvailable(String fontName) {
        List<String> availableFontFamilyNames = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        return availableFontFamilyNames.contains(fontName);
    }

    public static int getContentWidth(List<Word> words, Graphics2D graphics) throws IndexOutOfBoundsException, OptionException {
        if (words.size() < 1) {
            return 0;
        }
        return TextUtils.getContentWidth(words, graphics, 0, words.size() - 1);
    }

    public static boolean isBreakingDelimiter(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        return text.toCharArray()[0] == ' ';
    }

    public static boolean isWhitespace(String text) {
        if (text.length() > 0) {
            boolean nonBreakingWhitespaces = true;
            for (char c : text.toCharArray()) {
                if (c == '\u00a0') continue;
                nonBreakingWhitespaces = false;
            }
            return nonBreakingWhitespaces ? true : StringUtils.isWhitespace((String)text);
        }
        return false;
    }

    public static String updateUnicodeRange(String text, Font font) {
        if (font.canDisplayUpTo(text) != -1) {
            char[] newChars = new char[text.length()];
            for (int charIndex = 0; charIndex < text.length(); ++charIndex) {
                newChars[charIndex] = (char)(text.toCharArray()[charIndex] + 61440);
            }
            String updatedText = new String(newChars);
            if (font.canDisplayUpTo(updatedText) == -1) {
                return updatedText;
            }
        }
        return text;
    }
}

