/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Element;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Span;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.util.Map;

public class RootSpan
extends Span {
    private final int height;

    public RootSpan(Map<String, Option<?>> options, int height, Class<? extends Element> elementClass) throws OptionException {
        super(options, elementClass);
        this.height = height;
    }

    public RootSpan(Map<String, Option<?>> options, int height) throws OptionException {
        super(options);
        this.height = height;
    }

    @Override
    public void addTextElement(TextElement textElement) throws OptionException {
        textElement.setParent(this);
        super.addTextElement(textElement);
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextHeight(Graphics2D graphics, int xPos, int yPos) throws OptionException {
        int height = 0;
        for (Word word : this.getLeaves()) {
            height = Math.max(height, (int)Math.round(word.getTextBounds(graphics, xPos, yPos).getHeight()));
        }
        return height;
    }
}

