/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.LineWrap;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@TemplateElementType(type=TemplateNode.LI)
public class ListItem
extends TextElement {
    private List<TextElement> childElements = new ArrayList<TextElement>();
    private final LineWrap lineWrap;

    public ListItem(Map<String, Option<?>> options) throws OptionException {
        super(options, ListItem.class);
        this.lineWrap = (LineWrap)((Object)options.get(Attribute.WRAP.getKey()).get());
    }

    @Override
    public Collection<Attribute> getRequiredAttributes() {
        return Collections.emptyList();
    }

    public void addTextElement(TextElement child) {
        child.setParent(this);
        this.childElements.add(child);
    }

    public void clearTextElements() {
        this.childElements.clear();
    }

    @Override
    protected void graphicsObjectChanged(Graphics2D graphics) throws OptionException {
        for (TextElement childElement : this.childElements) {
            childElement.graphicsObjectChanged(graphics);
        }
    }

    @Override
    public List<Word> getLeaves() {
        ArrayList<Word> leaves = new ArrayList<Word>();
        for (TextElement childElement : this.childElements) {
            leaves.addAll(childElement.getLeaves());
        }
        return leaves;
    }

    @Override
    protected void propagateOptions() throws OptionException {
        for (TextElement childElement : this.childElements) {
            childElement.propagateOptions();
        }
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (TextElement childElement : this.childElements) {
            builder.append(childElement.getText());
        }
        return builder.toString();
    }

    @Override
    public Map<String, Option<?>> getOptions() {
        return super.getOptions();
    }

    public LineWrap getLineWrap() {
        return this.lineWrap;
    }
}

