/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.options.DescendingDoubleArrayOption;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.ListItem;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.TextUtils;
import at.mrdevelopment.toolkit.text.Word;
import at.mrdevelopment.toolkit.text.bullet.BulletPixelSpacing;
import at.mrdevelopment.toolkit.text.bullet.BulletSpacing;
import at.mrdevelopment.toolkit.text.bullet.BulletType;
import at.mrdevelopment.toolkit.text.bullet.BulletWord;
import at.mrdevelopment.toolkit.text.bullet.BulletWordSpacing;
import at.mrdevelopment.toolkit.text.bullet.ImageBullet;
import com.google.common.base.Joiner;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ListElement
extends TextElement {
    public static final String KEY_SPACING = "spacing";
    public static final String KEY_TYPE = "type";
    private final boolean ordered;
    private final boolean floating;
    private List<Word> words;
    private int lineCount = 0;
    private List<ListItem> listItems = new ArrayList<ListItem>();
    private Map<ListItem, List<Word>> bulletWords = new HashMap<ListItem, List<Word>>();
    private final String bulletImageFile;
    private File workingDirectory;

    public ListElement(Map<String, Option<?>> options, Class<? extends ListElement> elementClass, boolean ordered, File workingDirectory) throws OptionException {
        super(options, elementClass);
        this.ordered = ordered;
        this.workingDirectory = workingDirectory;
        this.floating = this.optionContainer.getBooleanOptionValue(Attribute.FLOAT.getKey());
        this.bulletImageFile = this.optionContainer.hasOption(Attribute.BULLET_IMAGE.getKey()) ? this.optionContainer.getStringOptionValue(Attribute.BULLET_IMAGE.getKey()) : null;
        this.words = new ArrayList<Word>();
    }

    public void addElement(ListItem listItem) throws OptionException, IllegalArgumentException {
        this.listItems.add(listItem);
        listItem.setParent(this);
        ArrayList<Word> newWords = new ArrayList<Word>();
        ++this.lineCount;
        List<Word> bullet = this.createBullet(listItem.getOptions());
        if (this.floating) {
            if (listItem.getLeaves().size() > 0) {
                Word word;
                Word firstWord = listItem.getLeaves().get(0);
                if (this.lineCount > 1) {
                    this.words.addAll(bullet);
                    newWords.addAll(bullet);
                    word = new Word(firstWord.getText(), firstWord.getOptions(), Word.RenderingHint.FLOAT, false);
                    this.words.add(word);
                    newWords.add(word);
                } else if (this.ordered) {
                    this.words.addAll(bullet);
                    newWords.addAll(bullet);
                    word = new Word(firstWord.getText(), firstWord.getOptions(), Word.RenderingHint.FLOAT, false);
                    this.words.add(word);
                    newWords.add(word);
                } else {
                    word = new Word(firstWord.getText(), firstWord.getOptions(), Word.RenderingHint.FLOAT, false);
                    this.words.add(word);
                    newWords.add(word);
                }
            } else {
                this.words.addAll(bullet);
                newWords.addAll(bullet);
            }
            if (listItem.getLeaves().size() > 1) {
                for (int index = 1; index < listItem.getLeaves().size(); ++index) {
                    Word tokenWord = new Word(listItem.getLeaves().get(index), false, Word.RenderingHint.FLOAT);
                    tokenWord.setParent(listItem);
                    this.words.add(tokenWord);
                    newWords.add(tokenWord);
                }
            }
        } else {
            if (this.lineCount > 1) {
                Word newLine = Word.newLineWord(listItem.getOptions(), true, Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT);
                newLine.setParent(listItem);
                this.words.add(newLine);
                newWords.add(newLine);
            }
            this.words.addAll(bullet);
            newWords.addAll(bullet);
            this.bulletWords.put(listItem, bullet);
            for (Word word : listItem.getLeaves()) {
                Word tokenWord = new Word(word, false, Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT);
                tokenWord.setParent(listItem);
                this.words.add(tokenWord);
                newWords.add(tokenWord);
            }
        }
        listItem.clearTextElements();
        for (Word word : newWords) {
            listItem.addTextElement(word);
        }
    }

    private List<Word> createBullet(Map<String, Option<?>> options) throws OptionException {
        ArrayList<Word> bulletWords = new ArrayList<Word>();
        BulletSpacing bulletSpacing = this.getBulletSpacing(options);
        if (this.ordered) {
            Word word1 = new Word(String.valueOf(this.lineCount), this.getBulletOptions(options), this.floating ? Word.RenderingHint.FLOAT : Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT, true);
            word1.setParent(this);
            bulletWords.add(word1);
        }
        if (this.hasBulletImage()) {
            ImageBullet bulletImageWord = new ImageBullet(this.getOptions(), this.workingDirectory, this.bulletImageFile, this.floating ? Word.RenderingHint.FLOAT : Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT, bulletSpacing);
            bulletImageWord.setParent(this);
            bulletWords.add(bulletImageWord);
        } else {
            Word word = new Word(this.getBullet(), this.getBulletOptions(options), this.floating ? Word.RenderingHint.FLOAT : Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT, true);
            BulletWord bulletWord = new BulletWord(this.floating ? Word.RenderingHint.FLOAT : Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT, bulletSpacing, word);
            bulletWords.add(bulletWord);
        }
        return bulletWords;
    }

    private BulletSpacing getBulletSpacing(Map<String, Option<?>> options) throws OptionException {
        if (this.getOptionContainer().hasOption(Attribute.SPACING.getKey()) && this.getOptionContainer().getOption(Attribute.SPACING.getKey()).get() != null) {
            int spacing = this.getOptionContainer().getIntegerOptionValue(Attribute.SPACING.getKey());
            return new BulletPixelSpacing(this.floating && this.lineCount > 1 ? spacing : 0, spacing);
        }
        Word word = new Word(" ", this.getBulletOptions(options), this.floating ? Word.RenderingHint.FLOAT : Word.RenderingHint.IGNORE_IF_NOT_DRAWN_CORRECT, true);
        return new BulletWordSpacing(word, this.floating && this.lineCount > 1);
    }

    private Map<String, Option<?>> getBulletOptions(Map<String, Option<?>> options) throws OptionException {
        HashMap bulletOptions = new HashMap();
        bulletOptions.putAll(options);
        Option<?> condenseOption = options.get(Attribute.CONDENSE_FACTOR.getKey());
        try {
            if (this.getOptionContainer().hasOption(Attribute.BULLET_FONT_FAMILY.getKey()) && this.getOptionContainer().getStringArrayOptionValue(Attribute.BULLET_FONT_FAMILY.getKey()) != null) {
                Option<?> fontFamilyOption = Attribute.FONT_FAMILY.createOption();
                Object[] fontArray = this.getOptionContainer().getStringArrayOptionValue(Attribute.BULLET_FONT_FAMILY.getKey());
                fontFamilyOption.setValueFromString(Joiner.on((String)",").join(fontArray));
                bulletOptions.put(Attribute.FONT_FAMILY.getKey(), fontFamilyOption);
            }
            DescendingDoubleArrayOption bulletCondenseOption = (DescendingDoubleArrayOption)Attribute.CONDENSE_FACTOR.createOption();
            bulletCondenseOption.setValueFromString(((Object[])condenseOption.get())[0].toString());
            bulletOptions.put(Attribute.CONDENSE_FACTOR.getKey(), bulletCondenseOption);
        }
        catch (Exception exc) {
            throw new OptionException(exc);
        }
        return bulletOptions;
    }

    private String getBullet() throws OptionException {
        String bulletString = this.getOptionContainer().getStringOptionValue(KEY_TYPE);
        String bullet = "";
        try {
            bullet = BulletType.valueOf(bulletString.toUpperCase()).getBullet();
        }
        catch (Exception exc) {
            bullet = bulletString;
        }
        return bullet;
    }

    @Override
    public List<Word> getLeaves() {
        return this.words;
    }

    @Override
    protected void propagateOptions() throws OptionException {
        for (Word textElement : this.words) {
            textElement.optionContainer.inherit(this.optionContainer);
            ((TextElement)textElement).propagateOptions();
        }
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (Word word : this.getLeaves()) {
            builder.append(word.getText());
        }
        return builder.toString();
    }

    public int getXOffsetForMultipleLines(Graphics2D graphics, ListItem listItem) throws OptionException {
        if (!this.floating && this.bulletWords.containsKey(listItem)) {
            return TextUtils.getContentWidth(this.bulletWords.get(listItem), graphics);
        }
        return 0;
    }

    @Override
    public boolean hasCondenseStepsRemaining() throws OptionException {
        boolean remaining = false;
        for (Word word : this.getLeaves()) {
            remaining = !remaining ? word.isSkipped() && word.hasCondenseStepsRemaining() : remaining;
        }
        return remaining;
    }

    public List<ListItem> getSkippedWordsListItems() {
        ArrayList<ListItem> skippedWordsItems = new ArrayList<ListItem>();
        for (ListItem listItem : this.listItems) {
            boolean hasSkippedWords = false;
            for (Word word : listItem.getLeaves()) {
                hasSkippedWords = hasSkippedWords ? true : word.isSkipped();
            }
            if (!hasSkippedWords) continue;
            skippedWordsItems.add(listItem);
        }
        return skippedWordsItems;
    }

    @Override
    public boolean nextFontSize() throws OptionException {
        boolean fontSizeChanged = false;
        List<ListItem> skippedWordsListItems = this.getSkippedWordsListItems();
        for (ListItem listItem : skippedWordsListItems) {
            for (Word word : listItem.getLeaves()) {
                boolean changed = word.nextFontSize();
                fontSizeChanged = fontSizeChanged ? true : changed;
            }
        }
        return fontSizeChanged;
    }

    @Override
    public boolean nextMinimumFontSize() throws OptionException {
        boolean fontSizeChanged = false;
        for (Word word : this.words) {
            boolean changed = word.nextMinimumFontSize();
            fontSizeChanged = fontSizeChanged ? true : changed;
        }
        return fontSizeChanged;
    }

    public boolean hasBulletImage() {
        return this.bulletImageFile != null;
    }
}

