/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.DrawLineStrategy;
import at.mrdevelopment.toolkit.text.Span;
import at.mrdevelopment.toolkit.text.TextLine;
import at.mrdevelopment.toolkit.text.Word;
import at.mrdevelopment.toolkit.text.bullet.ImageBullet;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class LeftAlignStrategy
extends DrawLineStrategy {
    @Override
    public Rectangle draw(TextLine textLine, Graphics2D graphics, int width, int height, int xPos, int yPos, int maxWidth) throws OptionException {
        return this.layout(textLine, graphics, width, height, xPos, yPos, maxWidth, true);
    }

    @Override
    public Rectangle getBounds(TextLine textLine, Graphics2D graphics, int width, int height, int xPos, int yPos, int maxWidth) throws OptionException {
        return this.layout(textLine, graphics, width, height, xPos, yPos, maxWidth, false);
    }

    private Rectangle layout(TextLine textLine, Graphics2D graphics, int width, int height, int xPos, int yPos, int maxWidth, boolean draw) throws OptionException {
        int largestAscent = textLine.getLargestAscent(graphics);
        Rectangle bounds = new Rectangle(new Point(xPos, yPos));
        for (int i = 0; i < textLine.getAllWords().size(); ++i) {
            Rectangle currentBounds;
            int currentYPos;
            Word word = textLine.getAllWords().get(i);
            int xAfterWord = word.getWidth(graphics);
            int heightOffset = largestAscent - word.getAscent(graphics);
            int n = currentYPos = word instanceof ImageBullet ? yPos : yPos + heightOffset;
            if (draw) {
                this.applyCompoundStyle(word, textLine, graphics, xPos, currentYPos, maxWidth);
                currentBounds = word.draw(graphics, width, height, xPos, currentYPos);
                bounds.add(currentBounds);
            } else {
                currentBounds = word.getBounds(graphics, xPos, currentYPos);
                bounds.add(currentBounds);
            }
            xPos += xAfterWord;
        }
        return bounds;
    }

    @Override
    protected Rectangle getSpanBoundsInLine(TextLine textLine, Span span, Word word, Graphics2D graphics, int xPos, int yPos, int maxWidth) throws OptionException {
        Rectangle bounds = null;
        List<Word> wordsInSpan = span.getLeaves();
        int largestAscent = textLine.getLargestAscent(graphics);
        for (Word spanWord : wordsInSpan) {
            if (!textLine.getAllWords().contains(spanWord)) continue;
            int xAfterWord = spanWord.getWidth(graphics);
            int heightOffset = largestAscent - spanWord.getAscent(graphics);
            if (bounds == null) {
                bounds = spanWord.getBounds(graphics, xPos, yPos + heightOffset);
            } else {
                bounds.add(spanWord.getBounds(graphics, xPos, yPos + heightOffset));
            }
            xPos += xAfterWord;
        }
        return bounds;
    }
}

