/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public enum GlyphSet {
    ASCII(33, 126),
    Greek(880, 1023),
    Currency(8352, 8399),
    Letters(8448, 8527),
    Operators(8704, 8959),
    Miscellaneous(8960, 9215),
    Borders(9472, 9599),
    Geometry(9600, 9727),
    Symbols(9728, 9983),
    Dingbats(9984, 10175),
    Arrows(10496, 10623);

    private final int first;
    private final int last;

    private GlyphSet(int first, int last) {
        this.first = first;
        this.last = last;
    }

    public List<String> getGlyphList(Font font) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = this.first; i <= this.last; ++i) {
            if (!font.canDisplay(i)) continue;
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(i);
            list.add(sb.toString());
        }
        return list;
    }

    public static String getGlyph(List<String> list, int index) {
        if (list.isEmpty()) {
            return null;
        }
        if (index < list.size()) {
            return list.get(index);
        }
        return "\ufffd";
    }

    public String toString() {
        return this.name();
    }

    public int getStart() {
        return this.first;
    }

    public Integer getEnd() {
        return this.last;
    }
}

