/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.text.JavaFontLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ESLFontLoader {
    static ESLLogger logger = ESLLogger.getLogger(ESLFontLoader.class);
    private static final File DEFAULT_FONT_DIRECTORY = new File("data/fonts");
    private File fontDirectory;
    private final JavaFontLoader fontLoader;
    private final Map<File, Font> loadedFonts = new HashMap<File, Font>();

    public ESLFontLoader() throws InitializationException {
        this(DEFAULT_FONT_DIRECTORY);
    }

    public ESLFontLoader(File fontDirectory) throws InitializationException {
        this.fontDirectory = fontDirectory;
        this.fontLoader = new JavaFontLoader();
    }

    public synchronized Map<File, Font> loadFonts() {
        HashMap<File, Font> fonts = new HashMap<File, Font>();
        if (this.fontDirectory.exists()) {
            Collection fontFiles = FileUtils.listFiles((File)this.fontDirectory, (String[])new String[]{"TTF", "ttf", "otf", "OTF"}, (boolean)true);
            int successfulRegistrations = 0;
            for (File fontFile : fontFiles) {
                if (this.loadedFonts.containsKey(fontFile)) {
                    fonts.put(fontFile, this.loadedFonts.get(fontFile));
                    continue;
                }
                try {
                    Font font = this.fontLoader.createFont(fontFile);
                    fonts.put(fontFile, font);
                    this.loadedFonts.put(fontFile, font);
                    if (this.fontAlreadyInstalled(font)) {
                        logger.info("Font %s already installed on the system", font.getName());
                        continue;
                    }
                    if (!this.fontLoader.registerFont(font)) {
                        logger.warn("Unable to install font from file %s", fontFile.getName());
                        continue;
                    }
                    ++successfulRegistrations;
                    logger.info("Font %s installed", fontFile.getName());
                }
                catch (Exception exc) {
                    logger.info("Could not load font from file %s: %s", fontFile.getName(), exc.getMessage());
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
            if (fontFiles.size() > 0) {
                logger.info("%d of %d fonts successfully installed", successfulRegistrations, fontFiles.size());
            }
        } else {
            logger.warn("Fonts directory (%s) does not exist", this.fontDirectory.getPath());
        }
        return fonts;
    }

    private boolean fontAlreadyInstalled(Font font) {
        Font[] availableFonts;
        for (Font availableFont : availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!availableFont.getName().equals(font.getName())) continue;
            return true;
        }
        return false;
    }

    public File getFontDirectory() {
        return this.fontDirectory;
    }

    public boolean isFontValid(InputStream inputStream) {
        try {
            Font font = this.fontLoader.createFont(inputStream);
            return font != null;
        }
        catch (FontFormatException exc) {
            logger.warn("Font not valid: %s", exc.getMessage());
            logger.logException(exc);
        }
        catch (IOException exc) {
            logger.warn("Font not valid: %s", exc.getMessage());
            logger.logException(exc);
        }
        return false;
    }
}

