/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.text;

import at.mrdevelopment.toolkit.definition.Attribute;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.text.Span;
import at.mrdevelopment.toolkit.text.TextElement;
import at.mrdevelopment.toolkit.text.TextLine;
import at.mrdevelopment.toolkit.text.Word;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class DrawLineStrategy {
    public abstract Rectangle draw(TextLine var1, Graphics2D var2, int var3, int var4, int var5, int var6, int var7) throws OptionException;

    public abstract Rectangle getBounds(TextLine var1, Graphics2D var2, int var3, int var4, int var5, int var6, int var7) throws OptionException;

    protected abstract Rectangle getSpanBoundsInLine(TextLine var1, Span var2, Word var3, Graphics2D var4, int var5, int var6, int var7) throws OptionException;

    protected void applyCompoundStyle(Word word, TextLine textLine, Graphics2D graphics, int xPos, int yPos, int maxWidth) throws OptionException {
        this.applyBackgroundStyle(word, textLine, graphics, xPos, yPos, maxWidth);
    }

    private void applyBackgroundStyle(Word word, TextLine textLine, Graphics2D graphics, int xPos, int yPos, int maxWidth) throws OptionException {
        TextElement textElement = word.getTopElementWithOptionSet(Attribute.BACKGROUND_COLOR.getKey());
        if (textElement instanceof Span) {
            Option<?> bgColorOption;
            Rectangle spanBounds;
            Span span = (Span)textElement;
            if (span != null && (textLine.isFirstInLine(word) || span.isFirstInSpan(word)) && (spanBounds = this.getSpanBoundsInLine(textLine, span, word, graphics, xPos, yPos, maxWidth)) != null && !(bgColorOption = span.optionContainer.getOption(Attribute.BACKGROUND_COLOR.getKey())).isDefault()) {
                graphics.setPaint(span.optionContainer.getColorOptionValue(Attribute.BACKGROUND_COLOR.getKey()));
                graphics.fill(spanBounds);
            }
        } else {
            Rectangle wordBounds = word.getBounds(graphics, xPos, yPos);
            Option<?> bgColorOption = word.optionContainer.getOption(Attribute.BACKGROUND_COLOR.getKey());
            if (!bgColorOption.isDefault()) {
                graphics.setPaint(word.optionContainer.getColorOptionValue(Attribute.BACKGROUND_COLOR.getKey()));
                graphics.fill(wordBounds);
            }
        }
    }
}

