/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.telnet;

import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.lancom.LancomInfo;
import at.mrdevelopment.toolkit.lancom.LancomInformationListener;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.apache.commons.net.telnet.TelnetClient;

public class LancomTelnetClient {
    private static ESLLogger logger = ESLLogger.getLogger(LancomTelnetClient.class);

    public void execute(String address, LancomInformationListener listener) {
        this.execute(address, 23, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String address, int port, LancomInformationListener listener) {
        TelnetClient client = new TelnetClient();
        InetAddress inetAddress = null;
        InputStreamReader reader = null;
        BufferedReader bufReader = null;
        String deviceName = null;
        String versionString = null;
        String serial = null;
        try {
            inetAddress = this.getAddress(address);
            if (inetAddress != null && this.connect(client, inetAddress, port)) {
                reader = new InputStreamReader(client.getInputStream(), Charset.forName("US-ASCII"));
                bufReader = new BufferedReader(reader);
                int infoCount = 3;
                while (infoCount > 0) {
                    String line = bufReader.readLine();
                    if (line == null) continue;
                    if (infoCount == 3 && line.contains("|")) {
                        deviceName = line.replace("|", "").trim();
                        --infoCount;
                        continue;
                    }
                    if (line.contains("Ver.")) {
                        versionString = line.trim();
                        --infoCount;
                        continue;
                    }
                    if (!line.contains("SN.")) continue;
                    serial = line.replace("| SN.", "").trim();
                    --infoCount;
                }
            }
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Problem reading lancom AP info via Telnet. Device address: %s.", inetAddress);
                logger.logException(ioe);
            }
        }
        finally {
            this.close(bufReader);
            this.close(reader);
            this.disconnect(client);
        }
        Version version = Version.UNDEFINED;
        try {
            if (versionString != null && !versionString.isEmpty()) {
                version = Version.fromLancomVersion(versionString);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        listener.notifyLancomInformation(new LancomInfo(-1, serial, deviceName, version));
    }

    private InetAddress getAddress(String address) {
        InetAddress inetAddress;
        block2: {
            inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException uhe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Could not resolve %s.", address);
                logger.logException(uhe);
            }
        }
        return inetAddress;
    }

    private boolean connect(TelnetClient client, InetAddress address, int port) {
        boolean retValue;
        block2: {
            retValue = false;
            try {
                client.setConnectTimeout(50);
                client.connect(address, port);
                client.setSoTimeout(50);
                retValue = true;
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Problem setting timeouts or establishing a connection to %s.", address.toString());
                logger.logException(ioe);
            }
        }
        return retValue;
    }

    private void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void disconnect(TelnetClient client) {
        if (client.isConnected()) {
            try {
                if (client.getInputStream() != null) {
                    client.getInputStream().close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

