/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class ThinAPTextPacket
extends ThinAPPacket {
    protected final BitSet fieldSet;
    private final List<AbstractKey> keys;
    private final boolean anyOptional;
    private boolean anyHeaderLineFailed;

    protected ThinAPTextPacket(ThinAPPacketIdentifier type, List<AbstractKey> keys) {
        super(type, Collections.<Feature>emptySet());
        this.fieldSet = new BitSet(keys.size());
        this.anyHeaderLineFailed = false;
        this.keys = keys;
        boolean optional = false;
        for (AbstractKey key : keys) {
            if (!key.isOptional()) continue;
            optional = true;
            break;
        }
        this.anyOptional = optional;
    }

    public boolean anyHeaderLineFailed() {
        return this.anyHeaderLineFailed;
    }

    public void headerLineFailed() {
        this.anyHeaderLineFailed = true;
    }

    void set(int idx) {
        this.fieldSet.set(idx);
    }

    @Override
    public boolean isValid() {
        if (this.anyHeaderLineFailed) {
            return false;
        }
        if (this.anyOptional) {
            boolean valid = true;
            for (AbstractKey key : this.keys) {
                if (key.isOptional() || this.fieldSet.get(key.idx)) continue;
                valid = false;
                break;
            }
            return valid;
        }
        return this.fieldSet.cardinality() == this.fieldSet.length();
    }
}

