/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.TextConstants;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.OutboundIntroductionResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;
import java.util.ArrayList;
import java.util.List;

public class OutboundIntroductionResponsePacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(OutboundIntroductionResponsePacket.class);
    private Byte protocolVersion;
    private OutboundIntroductionResponseCode responseCode;

    public OutboundIntroductionResponsePacket() {
        super(ThinAPPacketIdentifier.OUTBOUND_INTRODUCTION_RESPONSE, Key.KEYS);
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (Key.RESPONSE_CODE.getKey().equals(key)) {
            this.responseCode = OutboundIntroductionResponseCode.from(value);
            currentKey = Key.RESPONSE_CODE;
            if (this.responseCode == null) {
                this.headerLineFailed();
            }
        } else if (Key.PROTOCOL_VERSION.getKey().equals(key)) {
            this.protocolVersion = TextHelper.convertToByte(value);
            currentKey = Key.PROTOCOL_VERSION;
            if (this.protocolVersion == null) {
                this.headerLineFailed();
            }
        } else {
            logger.info("Introduction packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public OutboundIntroductionResponseCode getResponseCode() {
        return this.responseCode;
    }

    public static byte[] create(OutboundIntroductionResponseCode responseCode) {
        StringBuffer stb = new StringBuffer(128);
        stb.append((Object)ThinAPTextPacketKind.RESPONSE).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Introduction");
        TextHelper.addHeader(stb, "Response-Code", responseCode.getText());
        TextHelper.addHeader(stb, "Protocol-Version", 2);
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(2);
        static final Key RESPONSE_CODE = new Key("Response-Code");
        static final Key PROTOCOL_VERSION = new Key("Protocol-Version");

        protected Key(String key) {
            super(key);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

