/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.TextConstants;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;
import java.util.ArrayList;
import java.util.List;

public class OutboundIntroductionRequestPacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(OutboundIntroductionRequestPacket.class);
    private Byte protocolVersion;
    private Short eslChannel;
    private Integer accessPointId;
    private Version fwVersion;
    private String deviceType;
    private String swVersion;
    private Integer maxWindowSize;

    public OutboundIntroductionRequestPacket() {
        super(ThinAPPacketIdentifier.OUTBOUND_INTRODUCTION_REQUEST, Key.KEYS);
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (Key.AP_ID.getKey().equals(key)) {
            this.accessPointId = TextHelper.convertToInt(value);
            currentKey = Key.AP_ID;
            if (this.accessPointId == null) {
                this.headerLineFailed();
            }
        } else if (Key.PROTOCOL_VERSION.getKey().equals(key)) {
            this.protocolVersion = TextHelper.convertToByte(value);
            currentKey = Key.PROTOCOL_VERSION;
            if (this.protocolVersion == null) {
                this.headerLineFailed();
            }
        } else if (Key.MAX_WINDOW_SIZE.getKey().equals(key)) {
            this.maxWindowSize = TextHelper.convertToInt(value);
            currentKey = Key.MAX_WINDOW_SIZE;
            if (this.maxWindowSize == null) {
                this.headerLineFailed();
            }
        } else if (Key.ESL_CHANNEL.getKey().equals(key)) {
            this.eslChannel = TextHelper.convertToShort(value);
            currentKey = Key.ESL_CHANNEL;
            if (this.eslChannel == null) {
                this.headerLineFailed();
            }
        } else if (Key.FIRMWARE.getKey().equals(key)) {
            Version version = Version.fromStringIgnoreBranch(value);
            currentKey = Key.FIRMWARE;
            if (version == null) {
                this.headerLineFailed();
            } else {
                this.fwVersion = version;
            }
        } else if (Key.DEVICE_TYPE.getKey().equals(key)) {
            this.deviceType = value;
            currentKey = Key.DEVICE_TYPE;
            if (this.deviceType == null) {
                this.headerLineFailed();
            }
        } else if (Key.SOFTWARE.getKey().equals(key)) {
            this.swVersion = value;
            currentKey = Key.SOFTWARE;
            if (this.swVersion == null) {
                this.headerLineFailed();
            }
        } else {
            logger.info("Introduction packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public Byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public Short getEslChannel() {
        return this.eslChannel;
    }

    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public Version getFwVersion() {
        return this.fwVersion;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getSwVersion() {
        return this.swVersion;
    }

    public Integer getMaxWindowSize() {
        return this.maxWindowSize;
    }

    public static byte[] create(Short eslChannel, Integer apId, Version fwVersion, String deviceType, Version swVersion) {
        StringBuffer stb = new StringBuffer();
        stb.append((Object)ThinAPTextPacketKind.REQUEST).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Introduction");
        TextHelper.addHeader(stb, "Protocol-Version", 2);
        TextHelper.addHeader(stb, "Max-Window-Size", 14);
        TextHelper.addHeader(stb, "Esl-Channel", Short.toString(eslChannel));
        TextHelper.addHeader(stb, "Ap-Id", Integer.toString(apId));
        TextHelper.addHeader(stb, "Firmware", fwVersion.getVersionString());
        TextHelper.addHeader(stb, "Device-Type", deviceType);
        TextHelper.addHeader(stb, "Software", swVersion.getVersionString());
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(7);
        static final Key AP_ID = new Key("Ap-Id");
        static final Key PROTOCOL_VERSION = new Key("Protocol-Version");
        static final Key MAX_WINDOW_SIZE = new Key("Max-Window-Size");
        static final Key ESL_CHANNEL = new Key("Esl-Channel");
        static final Key FIRMWARE = new Key("Firmware");
        static final Key DEVICE_TYPE = new Key("Device-Type");
        static final Key SOFTWARE = new Key("Software");

        protected Key(String key) {
            super(key);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

